import Colors from "./Colors";

export default new class {
    private colorHexs: Array<string> = [];
    private coverMsgs: Array<string> = [];
    public cover(msg: string, bottomTxt: cc.Label, ...coverTxts: Array<cc.Label>): void {
        bottomTxt.string = msg.replace(/<[^<>]*>/g, "");
        const matchArr = msg.match(/<[^<>]*>[^<>]*<[^<>]*>|[^<>]+/g);
        this.colorHexs.length = 0;
        this.coverMsgs.length = 0;
        let i: number = -1;
        for (const coverTxt of coverTxts) {
            i++;
            this.coverMsgs[i] = "";
        }
        if (matchArr) {
            for (const _matchStr of matchArr) {
                let index: number;
                let str: string;

                if (_matchStr.startsWith("<")) {
                    const matchArr2 = _matchStr.match(/^<\s*color=#(\w{6})\s*>\s*(.*?)\s*<\s*\/\s*color\s*>$/);
                    const colorHex = matchArr2[1];
                    index = this.colorHexs.indexOf(colorHex);
                    index > -1 || (index = this.colorHexs.length, this.colorHexs[index] = colorHex);
                    str = matchArr2[2];
                } else {
                    index = -1;
                    str = _matchStr;
                }

                const letterDefs = bottomTxt.font._fontDefDictionary._letterDefinitions;
                const len = str.length;
                let strCover: string = "";
                for (let i: number = 0; i < len; i++) {
                    const c = str.charCodeAt(i);
                    //coverMsg += c > 0xff ? "　"/*"囗"*/ : " "
                    const letterDef = letterDefs[c];
                    if (letterDef) {
                        if (letterDef.castCover) {
                            //console.log(str[i] + " " + c + " 已有映射：" + String.fromCharCode(letterDef.castCover) + " " + letterDef.castCover + "，直接使用");
                        } else {
                            const castLetterDef = JSON.parse(JSON.stringify(letterDef));
                            castLetterDef.u = castLetterDef.v = 2048;
                            let castCover: number = c;
                            while (letterDefs[++castCover]) { };
                            letterDefs[castCover] = castLetterDef;
                            letterDef.castCover = castLetterDef.castCover = castCover;
                            //console.log(str[i] + " " + c + " 映射为：" + String.fromCharCode(letterDef.castCover) + " " + letterDef.castCover);
                        }
                        strCover += String.fromCharCode(letterDef.castCover);
                    } else {//\n 之类的
                        strCover += str.charAt(i);
                    }
                }

                let j: number = this.coverMsgs.length;
                while (j--) {
                    this.coverMsgs[j] += j == index ? str : strCover;
                }
            }
        }
        i = -1;
        for (const coverTxt of coverTxts) {
            i++;
            if (this.colorHexs[i]) {
                coverTxt.string = this.coverMsgs[i];
                coverTxt.node.color = Colors.get(this.colorHexs[i]);
            } else {
                coverTxt.string = "";
            }
        }
    }
    // public 单行拼接(msg: string, prefabName: string = "label矢量", fontSize: number = 48): cc.Node {
    //     const txts = new cc.Node("txts");
    //     let wid: number = 0;
    //     for (const part of msg.match(/<[^<>]*>[^<>]*<[^<>]*>|[^<>]+/g)) {
    //         const txt = Prefabs.instantiate(prefabName);
    //         txts.addChild(txt);
    //         txt.anchorX = 0;
    //         const label = txt.getComponent(cc.Label);
    //         label.verticalAlign = cc.Label.VerticalAlign.CENTER;
    //         label.fontSize = fontSize;
    //         txt.x = wid;
    //         const matchArr = part.match(/^<\s*color=#(\w{6}\s*>\s*(.*?)\s*<\s*\/\s*color\s*>)$/);
    //         if (matchArr) {
    //             txt.color = Colors.get(matchArr[1]);
    //             label.string = matchArr[2];
    //         } else {
    //             label.string = part;
    //         }
    //         label._forceUpdateRenderData();
    //         wid += txt.width * txt.scale;
    //     }
    //     txts.width = wid;
    //     return txts;
    // }
}
