import files from "./files";

export type PojType = "cc24" | "cc38" | "tj1";
export default new class {
    public getType(pojPath: string): PojType {
        let version: string = undefined!;
        const projectVersionTxtPath = pojPath + "ProjectSettings/ProjectVersion.txt";
        if (files.isFile(projectVersionTxtPath)) {
            version = files.readStr(projectVersionTxtPath).match(/m_TuanjieEditorVersion: ([\d.]+)/)?.[1]!;
            if (version?.startsWith("1.7.")) {
                return "tj1";
            } else {
                console.error("不支持的版本：" + version);
            }
        } else {
            const projectJSONPath = pojPath + "project.json";
            if (files.isFile(projectJSONPath)) {
                version = files.readStr(projectJSONPath).match(/"version": "([\d.]+)"/)?.[1]!;
                if (version?.startsWith("2.4.")) {
                    return "cc24";
                } else {
                    console.error("不支持的版本：" + version);
                }
            } else {
                const packageJSONPath = pojPath + "package.json";
                if (files.isFile(packageJSONPath)) {
                    version = files.readStr(packageJSONPath).match(/"version": "([\d.]+)"/)?.[1]!;
                    if (version?.startsWith("3.8.")) {
                        return "cc38";
                    } else {
                        console.error("不支持的版本：" + version);
                    }
                }
            }
        }
        console.error("未知项目类型：" + pojPath);
        return undefined!;
    }
}