import CheckChanges from "./CheckChanges";
import Utils from "./Utils"
import files from "./files";

export default new class {
    public doo(): boolean {
        const srcDirPath = Utils.appDirPath + "source/src/";
        if (CheckChanges.check(srcDirPath)) {
            const sb: string[] = [];
            let sbIndex: number = 0;
            const sb2: string[] = [];
            let sb2Index: number = 0;
            sb[sbIndex++] = 'import Entry from "./src/Entry"\n';
            for (const filePath of files.getFilePaths(srcDirPath + "pages/", false)) {
                const pageName = filePath.match(/\/([^\/]+)\.ts$/)?.[1]!;
                if (pageName == "Page") continue;
                sb[sbIndex++] = 'import ';
                sb[sbIndex++] = pageName;
                sb[sbIndex++] = ' from "./src/pages/';
                sb[sbIndex++] = pageName;
                sb[sbIndex++] = '"\n';
                sb2[sb2Index++] = '    ';
                sb2[sb2Index++] = pageName;
                sb2[sb2Index++] = ': ';
                sb2[sb2Index++] = pageName;
                sb2[sb2Index++] = ',\n';
            }
            sb[sbIndex++] = 'Entry.init({\n';
            sb[sbIndex++] = sb2.join("");
            sb[sbIndex++] = '});';
            files.checkAndWrite(Utils.appDirPath + "source/index.ts", sb.join(""));
            tsup.build({
                entry: [Utils.appDirPath + "source/index.ts"],
                minify: true,
                clean: true,
                tsconfig: Utils.appDirPath + "source/tsconfig.json",
                outDir: Utils.appDirPath + "source/dist/",
                async onSuccess() {
                    CheckChanges.mark(srcDirPath);
                    window.location.reload();
                }
            });
            return true;
        }
        return false;
    }
}