import Sharps from "./Sharps";

export default new class {
    private icon0!: sharp.Sharp;
    public async 读取原图标(filePath: string): Promise<string> {
        const sharp = await Sharps.fromFile(filePath);
        this.icon0 = sharp.img;
        return sharp.failReason;
    }
    public async doo(filePath: string): Promise<string> {
        const sharp = await Sharps.fromFile(filePath);
        if (sharp.failReason) { } else {
            const rgbas = await Sharps.getRGBAs(sharp.img);

            const _icon0 = this.icon0.clone();
            _icon0.resize(sharp.wid, sharp.hei);
            const rgbas0 = await Sharps.getRGBAs(_icon0);
            _icon0.destroy();

            let i: number = rgbas0.length;
            while ((i -= 4) >= 0) {
                rgbas0[i + 3] = rgbas[i + 3]!;
            }

            const newIcon = Sharps.fromRGBAs(rgbas0, sharp.wid, sharp.hei);
            await (/\.png$/i.test(filePath) ? newIcon.png() : newIcon.jpeg()).toFile(filePath);
            newIcon.destroy();
        }
        sharp.img?.destroy();
        return sharp.failReason;
    }
    public done(): void {
        if (this.icon0) {
            this.icon0.destroy();
            this.icon0 = undefined!;
        }
    }
}