//https://blog.csdn.net/a200710716/article/details/51644421
//https://pkware.cachefly.net/webdocs/APPNOTE/APPNOTE-6.2.0.txt

import files from "./files";

// import { UTF8 } from "./UTF8";
export default new class {
    public doo(zipPath: string): void {
        const bytes = files.readBytes(zipPath);
        const len = bytes.length;
        let offset: number = 0;
        while (offset < len) {
            const header = bytes[offset++]! | (bytes[offset++]! << 8) | (bytes[offset++]! << 16) | (bytes[offset++]! << 24);
            switch (header) {
                case 0x04034b50:
                    {
                        //0	4	Local file header signature = 0x04034b50 (read as a little-endian number)	文件头标识，值固定(0x04034b50)

                        //4	2	Version needed to extract (minimum)	解压文件所需 pkware最低版本
                        offset += 2;

                        //6	2	General purpose bit flag	通用比特标志位(置比特0位=加密，详情见后)
                        offset += 2;

                        //8	2	Compression method	压缩方式（详情见后）
                        offset += 2;

                        //10	2	File last modification time	文件最后修改时间
                        //12	2	File last modification date	文件最后修改日期
                        this.修改老时间戳(bytes, offset);
                        offset += 4;

                        //14	4	CRC-32	CRC-32校验码
                        offset += 4;

                        //18	4	Compressed size	压缩后的大小
                        const compressed_size = bytes[offset++]! | (bytes[offset++]! << 8) | (bytes[offset++]! << 16) | (bytes[offset++]! << 24);

                        //22	4	Uncompressed size	未压缩的大小
                        offset += 4;
                        // const uncompressed_size = bytes[offset++] | (bytes[offset++] << 8) | (bytes[offset++] << 16) | (bytes[offset++] << 24);
                        // console.log(
                        //     "compressed_size=" + compressed_size + "\n" +
                        //     "uncompressed_size=" + uncompressed_size
                        // );

                        //26	2	File name length (n)	文件名长度
                        //28	2	Extra field length (m)	扩展区长度
                        const file_name_length = bytes[offset++]! | (bytes[offset++]! << 8);
                        const extra_field_length = bytes[offset++]! | (bytes[offset++]! << 8);

                        //30	n	File name	文件名
                        //console.log("04034b50 " + iconv.decode(bytes.slice(offset, offset + file_name_length), "gbk"));
                        offset += file_name_length;

                        //30+n	m	Extra field	扩展区
                        this.修改新时间戳(bytes, offset, extra_field_length);
                        offset += extra_field_length;

                        offset += compressed_size;
                    }
                    break;
                case 0x02014b50:
                    {
                        // 0	4	Central directory file header signature = 0x02014b50	核心目录文件header标识=（0x02014b50）

                        // 4	2	Version made by	压缩所用的pkware版本
                        offset += 2;

                        // 6	2	Version needed to extract (minimum)	解压所需pkware的最低版本
                        offset += 2;

                        // 8	2	General purpose bit flag	通用位标记
                        offset += 2;

                        // 10	2	Compression method	压缩方法
                        offset += 2;

                        // 12	2	File last modification time	文件最后修改时间
                        // 14	2	File last modification date	文件最后修改日期
                        this.修改老时间戳(bytes, offset);
                        offset += 4;

                        // 16	4	CRC-32	CRC-32校验码
                        offset += 4;

                        // 20	4	Compressed size	压缩后的大小
                        offset += 4;

                        // 24	4	Uncompressed size	未压缩的大小
                        offset += 4;

                        // 28	2	File name length (n)	文件名长度
                        // 30	2	Extra field length (m)	扩展域长度
                        // 32	2	File comment length (k)	文件注释长度
                        const file_name_length = bytes[offset++]! | (bytes[offset++]! << 8);
                        const extra_field_length = bytes[offset++]! | (bytes[offset++]! << 8);
                        const file_comment_length = bytes[offset++]! | (bytes[offset++]! << 8);

                        // 34	2	Disk number where file starts	文件开始位置的磁盘编号
                        offset += 2;

                        // 36	2	Internal file attributes	内部文件属性
                        offset += 2;

                        // 38	4	External file attributes	外部文件属性
                        offset += 4;

                        // 42	4	relative offset of local header	本地文件头的相对位移
                        offset += 4;

                        // 46	n	File name	目录文件名
                        //console.log("02014b50 " + iconv.decode(bytes.slice(offset, offset + file_name_length), "gbk"));
                        offset += file_name_length;

                        // 46+n	m	Extra field	扩展域
                        this.修改新时间戳(bytes, offset, extra_field_length);
                        offset += extra_field_length;

                        // 46+n+m	k	File comment	文件注释内容
                        offset += file_comment_length;
                    }
                    break;
                case 0x06054b50:
                    {
                        // 0	4	End of central directory signature = 0x06054b50	核心目录结束标记（0x06054b50）

                        // 4	2	Number of this disk	当前磁盘编号
                        offset += 2;

                        // 6	2	number of the disk with the start of the central directory	核心目录开始位置的磁盘编号
                        offset += 2;

                        // 8	2	total number of entries in the central directory on this disk	该磁盘上所记录的核心目录数量
                        offset += 2;

                        // 10	2	total number of entries in the central directory	核心目录结构总数
                        offset += 2;

                        // 12	4	Size of central directory (bytes)	核心目录的大小
                        offset += 4;

                        // 16	4	offset of start of central directory with respect to the starting disk number	核心目录开始位置相对于archive开始的位移
                        offset += 4;

                        // 20	2	.ZIP file comment length(n)	注释长度
                        const file_comment_length = bytes[offset++]! | (bytes[offset++]! << 8);

                        // 22	n	.ZIP Comment	注释内容
                        offset += file_comment_length;
                    }
                    break;
                default:
                    console.error(offset + " 未处理的 header：0x" + header.toString(16));
                    return;
                    break;
            }
        }
        files.checkAndWrite(zipPath, bytes);
    }

    private 修改老时间戳(bytes: Buffer, offset: number): void {
        bytes[offset++] = 0x13;
        bytes[offset++] = 0x7f;
        bytes[offset++] = 0xfc;
        bytes[offset++] = 0x52;
    }

    private 修改新时间戳(bytes: Buffer, offset: number, extra_field_length: number): void {
        //           Value      Size       Description
        //           -----      ----       -----------
        //   (NTFS)  0x000a     2 bytes    Tag for this "extra" block type
        //           TSize      2 bytes    Size of the total "extra" block
        //           Reserved   4 bytes    Reserved for future use
        //           Tag1       2 bytes    NTFS attribute tag value #1
        //           Size1      2 bytes    Size of attribute #1, in bytes
        //           (var.)     Size1      Attribute #1 data
        //           .
        //           .
        //           .
        //           TagN       2 bytes    NTFS attribute tag value #N
        //           SizeN      2 bytes    Size of attribute #N, in bytes
        //           (var.)     SizeN      Attribute #N data

        //           For NTFS, values for Tag1 through TagN are as follows:
        //           (currently only one set of attributes is defined for NTFS)

        //           Tag        Size       Description
        //           -----      ----       -----------
        //           0x0001     2 bytes    Tag for attribute #1 
        //           Size1      2 bytes    Size of attribute #1, in bytes
        //           Mtime      8 bytes    File last modification time
        //           Atime      8 bytes    File last access time
        //           Ctime      8 bytes    File creation time
        if (extra_field_length >= 36) {
            //   (NTFS)  0x000a     2 bytes    Tag for this "extra" block type
            if (
                bytes[offset++] == 0x0a &&
                bytes[offset++] == 0x00
            ) {
                //           TSize      2 bytes    Size of the total "extra" block
                offset += 2;

                //           Reserved   4 bytes    Reserved for future use
                offset += 4;

                //           0x0001     2 bytes    Tag for attribute #1 
                if (
                    bytes[offset++] == 0x01 &&
                    bytes[offset++] == 0x00
                ) {
                    //           Size1      2 bytes    Size of attribute #1, in bytes
                    offset += 2;

                    //           Mtime      8 bytes    File last modification time
                    //           Atime      8 bytes    File last access time
                    //           Ctime      8 bytes    File creation time
                    for (let i: number = 0; i < 3; i++) {
                        bytes[offset++] = 0x5d;
                        bytes[offset++] = 0x5f;
                        bytes[offset++] = 0x69;
                        bytes[offset++] = 0xc6;
                        bytes[offset++] = 0x91;
                        bytes[offset++] = 0x83;
                        bytes[offset++] = 0xd7;
                        bytes[offset++] = 0x01;
                    }
                }
            }
        }
    }
}