import { RenameArgs } from "./Store";

export default new class {
    // public constructor() {
    //     (window as any).批量重命名 = this;
    // }
    private dirNameExt: RegExp = /^(.+\/)([^\/]*?)(\.\w+)?$/;
    private n: RegExp = /\{n\}/g;
    private reg!: RegExp;
    private sb: string[] = [];
    public setReg(args: RenameArgs): void {
        this.reg = new RegExp(args.reg);
    }
    private 左补零(num: number, digits: number): string {
        if (digits > 0) {
            let str: string = num + "";
            let rest: number = digits - str.length;
            while (--rest >= 0) {
                str = "0" + str;
            }
            return str;
        }
        return "";
    }
    public rename(args: RenameArgs, index: number, src: string): string {
        this.sb.length = 0;
        let sbIndex: number = 0;
        const matchArr = src.match(this.dirNameExt)!;
        matchArr[3] || (matchArr[3] = "");
        this.sb[sbIndex++] = matchArr[1]!;
        switch (args.mode) {
            case "正则":
                this.sb[sbIndex++] = (matchArr[2] + matchArr[3]).replace(this.reg, args.replace.replace(this.n, this.左补零(index + 1, args.编号位数)));
                break;
            default:
                args.prefix && (this.sb[sbIndex++] = args.prefix);
                this.sb[sbIndex++] = this.左补零(index + 1, args.编号位数);
                this.sb[sbIndex++] = matchArr[3];
                break;
        }
        return this.sb.join("");
    }
}