import files from "./files";

export default new class {
    public dirPath!: string;
    private currId!: number;
    public init(_dirPath: string): void {
        files.clearOrMakeDir(this.dirPath = _dirPath);
        this.currId = 10000 + Math.random() * 10000 >>> 0;
    }
    public getFilePath(ext: string): string {
        return this.dirPath + (++this.currId) + ext;
    }
    public getDirPath(): string {
        return this.dirPath + (++this.currId) + "/";
    }
}