declare enum ENUM_PINYIN_STYLE {
    NORMAL = 0,
    TONE = 1,
    TONE2 = 2,
    TO3NE = 5,
    INITIALS = 3,
    FIRST_LETTER = 4,
    PASSPORT = 6
}
declare enum ENUM_PINYIN_MODE {
    NORMAL = 0,
    SURNAME = 1
}
declare const DEFAULT_OPTIONS: IPinyinAllOptions;
declare const PHONETIC_SYMBOL: Record<string, string>;
declare const INITIALS: string[];
declare const FINALS: string[];

declare function pinyin(han: string, options?: IPinyinOptions): string[][];
declare namespace pinyin {
    declare function compare(a: string, b: string): number;
    declare function compact(arr: string[][]): string[][];
    declare const STYLE_TONE: ENUM_PINYIN_STYLE;
    declare const STYLE_TONE2: ENUM_PINYIN_STYLE;
    declare const STYLE_TO3NE: ENUM_PINYIN_STYLE;
    declare const STYLE_NORMAL: ENUM_PINYIN_STYLE;
    declare const STYLE_INITIALS: ENUM_PINYIN_STYLE;
    declare const STYLE_FIRST_LETTER: ENUM_PINYIN_STYLE;
    declare const STYLE_PASSPORT: ENUM_PINYIN_STYLE;
    declare const MODE_NORMAL: ENUM_PINYIN_MODE;
    declare const MODE_SURNAME: ENUM_PINYIN_MODE;
}
declare type IPinyinStyle = ENUM_PINYIN_STYLE | "normal" | "tone" | "tone2" | "to3ne" | "initials" | "first_letter" | "passport" | // 推荐使用小写，和输出的拼音一致
    "NORMAL" | "TONE" | "TONE2" | "TO3NE" | "INITIALS" | "FIRST_LETTER" | "PASSPORT" | // 方便老版本迁移
    0 | 1 | 2 | 5 | 3 | 4;
declare type IPinyinMode = ENUM_PINYIN_MODE | "normal" | "surname" | "NORMAL" | "SURNAME";
declare type IPinyinSegment = "nodejieba" | "segmentit" | "@node-rs/jieba" | "Intl.Segmenter";
declare interface IPinyinAllOptions {
    style: ENUM_PINYIN_STYLE;
    mode: ENUM_PINYIN_MODE;
    segment?: IPinyinSegment;
    heteronym: boolean;
    group: boolean;
    compact: boolean;
}
declare interface IPinyinOptions {
    style?: IPinyinStyle;
    mode?: IPinyinMode;
    segment?: IPinyinSegment | boolean;
    heteronym?: boolean;
    group?: boolean;
    compact?: boolean;
}
