import fs from "fs";
import Hex from "./Hex";

const sb: string[] = [];
const sb2: string[] = [];
export default new class {
    public constructor() {
        (window as any).files = this;
    }
    public mkdir(dirPath: string): void {
        const stats = this.stat(dirPath);
        if (stats) {
            if (stats.isDirectory()) return;
            console.error("不是目录：" + dirPath);
        } else {
            fs.mkdirSync(dirPath, { recursive: true });
        }
    }
    public mkParentDir(filePath: string): void {
        this.mkdir(filePath.replace(/[^\/]+$/, ""));
    }
    public rmdir(dirPath: string): void {
        if (this.isDir(dirPath)) {
            fs.rmdirSync(dirPath, { recursive: true });
        }
    }
    public clearOrMakeDir(dirPath: string): void {
        this.rmdir(dirPath);
        fs.mkdirSync(dirPath, { recursive: true });
    }
    public open(fileOrDirPath: string): void {
        shell.openPath(fileOrDirPath);
    }
    public openLink(fileOrDirPath: string, showPart: number = 0): string {
        if (fileOrDirPath) {
            sb.length = 0;
            let sbIndex: number = 0;
            sb2.length = 0;
            let sb2Index: number = 0;
            const parts = fileOrDirPath.match(/[^\/]+\/?/g)!;
            let rest: number = parts.length;
            showPart > 0 || (showPart = rest);
            for (const part of parts) {
                sb2[sb2Index++] = part;
                if (--rest < showPart) {
                    const path = sb2.join("");
                    sb[sbIndex++] = '<a href="javascript:files.open(\'';
                    sb[sbIndex++] = path;
                    sb[sbIndex++] = '\')"';
                    if (this.isDir(path) || this.isFile(path)) { } else {
                        sb[sbIndex++] = ' style="color:red;"';
                    }
                    sb[sbIndex++] = '>';
                    sb[sbIndex++] = part;
                    sb[sbIndex++] = '</a>';
                }
            }
            return sb.join("");
        }
        return "";
    }
    public select(fileOrDirPath: string): void {
        if (this.isFile(fileOrDirPath)) {
            // this.open(fileOrDirPath.replace(/[^\/\\]+$/, ""));
            shell.showItemInFolder(fileOrDirPath);
        } else if (this.isDir(fileOrDirPath)) {
            this.open(fileOrDirPath);
        } else {
            console.error("找不到 " + fileOrDirPath);
        }
    }
    public isFile(filePath: string): boolean {
        return this.stat(filePath)?.isFile();
    }
    public isDir(dirPath: string): boolean {
        return this.stat(dirPath)?.isDirectory();
    }
    public stat(fileOrDirPath: string): fs.Stats {
        try {
            return fs.statSync(fileOrDirPath);
        } catch (e) { }
        return undefined!;
    }

    public deleteFile(filePath: string): void {
        fs.unlinkSync(filePath);
    }
    public copyFiles(src: string, dest: string): void {
        for (const srcPath of this.getFilePaths(src, true)) {
            const destPath = srcPath.replace(src, dest);
            this.mkParentDir(destPath);
            this.copyFile(srcPath, destPath);
        }
    }
    public copyFile(src: string, dest: string): void {
        fs.copyFileSync(src, dest);
    }
    public cutDir(src: string, dest: string): void {
        fs.renameSync(src, dest);
    }
    public cutFile(src: string, dest: string): void {
        fs.renameSync(src, dest);
    }

    public readBytes(filePath: string): Buffer {
        return fs.readFileSync(filePath);
    }
    public writeBytes(filePath: string, bytes: Uint8Array): void {
        fs.writeFileSync(filePath, bytes);
    }
    public gbkBytes2Str(bytes: Buffer): string {
        return iconv.decode(bytes, "gbk");
    }
    public str2GBKBytes(str: string): Buffer {
        return iconv.encode(str, "gbk");
    }
    public addUTF8BOM(str: string): Buffer {
        return Buffer.from("\ufeff" + str, "utf8");
    }
    public readStr(filePath: string, encoding: "utf8" | "gbk" = "utf8"): string {
        switch (encoding) {
            case "gbk":
                return this.gbkBytes2Str(this.readBytes(filePath));
            default:
                return fs.readFileSync(filePath, encoding);
        }
    }
    public writeStr(filePath: string, str: string, encoding: "utf8" | "gbk" = "utf8"): void {
        switch (encoding) {
            case "gbk":
                this.writeBytes(filePath, this.str2GBKBytes(str));
                break;
            default:
                fs.writeFileSync(filePath, str, encoding);
                break;
        }
    }
    public checkAndWrite(filePath: string, bytesOrStr: Uint8Array | string, info: string = "", output?: (label: string, filePath: string) => void): boolean {
        if (this.isFile(filePath)) {
            if (bytesOrStr instanceof Uint8Array) {
                if (this.isSameBytes(this.readBytes(filePath), bytesOrStr)) return false;
            } else {
                if (this.readStr(filePath) == bytesOrStr) return false;
            }
        }
        if (bytesOrStr instanceof Uint8Array) {
            this.writeBytes(filePath, bytesOrStr);
        } else {
            this.writeStr(filePath, bytesOrStr as string);
        }
        console.log("写入" + info + "至：" + filePath);
        output?.(info + "：", filePath);
        return true;
    }
    public isSameBytes(bytes1: Uint8Array, bytes2: Uint8Array): boolean {
        if (bytes1.length == bytes2.length) {
            let i: number = bytes1.length;
            while (i--) {
                if (bytes1[i] == bytes2[i]) { } else return false;
            }
            return true;
        }
        return false;
    }
    public getDirOrFilePaths(dirPath: string, recursive: boolean): string[] {
        const dirOrFilePaths: string[] = [];
        dirPath = this.normalizeDirPath(dirPath);
        let i: number = -1;
        for (const path of fs.readdirSync(dirPath, { recursive: recursive })) {
            const dirOrFilePath = dirPath + path;
            dirOrFilePaths[++i] = this.isDir(dirOrFilePath) ? this.normalizeDirPath(dirOrFilePath) : this.normalizeFilePath(dirOrFilePath);
        }
        this.sort(dirOrFilePaths);
        return dirOrFilePaths;
    }
    public getDirPaths(dirPath: string, recursive: boolean): string[] {
        const dirPaths: string[] = [];
        dirPath = this.normalizeDirPath(dirPath);
        let i: number = -1;
        for (const path of fs.readdirSync(dirPath, { recursive: recursive })) {
            const subDirPath = dirPath + path;
            if (this.isDir(subDirPath)) {
                dirPaths[++i] = this.normalizeDirPath(subDirPath);
            }
        }
        this.sort(dirPaths);
        return dirPaths;
    }
    public getFilePaths(dirPath: string, recursive: boolean, ...ends: string[]): string[] {
        const filePaths: string[] = [];
        dirPath = this.normalizeDirPath(dirPath);
        let filePath: string;
        let i: number = ends.length;
        if (i) {
            while (i--) {
                ends[i] = ends[i]!.toLocaleLowerCase();
            }
            i = -1;
            for (const path of fs.readdirSync(dirPath, { recursive: recursive })) {
                filePath = dirPath + path;
                if (this.isFile(filePath)) {
                    filePath = this.normalizeFilePath(filePath);
                    const filePathLower = filePath.toLowerCase();
                    for (const end of ends) {
                        if (filePathLower.endsWith(end)) {
                            filePaths[++i] = filePath;
                            break;
                        }
                    }
                }
            }
        } else {
            i = -1;
            for (const path of fs.readdirSync(dirPath, { recursive: recursive })) {
                filePath = dirPath + path;
                if (this.isFile(filePath)) {
                    i++;
                    filePaths[i] = this.normalizeFilePath(filePath);
                }
            }
        }
        // console.log(dirPath, filePaths.length);
        this.sort(filePaths);
        return filePaths;
    }
    private sort(strs: string[]): void {
        const strIndices: { [key: string]: number } = {};
        const cankaoStrs: string[] = [];
        let i: number = -1;
        for (const str of strs) {
            i++;
            sb.length = 0;
            let sbIndex: number = 0;
            for (const matchStr of str.match(/\d+|\D+/g)!) {
                if (matchStr.length < 10 && /\d/.test(matchStr)) {
                    let j: number = 10 - matchStr.length;
                    while (j--) {
                        sb[sbIndex++] = "\n";
                    }
                }
                sb[sbIndex++] = matchStr;
            }
            const cankaoStr = cankaoStrs[i] = Hex.bytes2str(new Uint8Array(this.str2GBKBytes(sb.join(""))));
            strIndices[cankaoStr] = i;
        }
        cankaoStrs.sort();
        const L = strs.length;
        for (const cankaoStr of cankaoStrs) {
            strs.push(strs[strIndices[cankaoStr]!]!);
        }
        strs.splice(0, L);
    }
    public baseDir(base: string, path: string): string {
        return this.normalizeDirPath(/^\w:/.test(path) ? path : base + "/" + path);
    }
    public baseFile(base: string, path: string): string {
        return this.normalizeFilePath(/^\w:/.test(path) ? path : base + "/" + path);
    }
    public normalizeDirPath(dirPath: string): string {
        return dirPath && this.normalizePath(dirPath + "/");
    }
    public normalizeFilePath(filePath: string): string {
        return filePath && this.normalizePath(filePath.replace(/[\/\\]+$/, ""));
    }
    private normalizePath(path: string): string {
        path = path.replace(/[\/\\]+/g, "/");
        if (path.includes("..")) {
            const arr = path.split("/");
            let index: number;
            while ((index = arr.indexOf("..")) > 0) {
                arr.splice(index - 1, 2);
            }
            path = arr.join("/");
        }
        return path.replace(/\/\.\//g, "/");
    }

    public dirPath!: string;
    public dirNotOKReason(dirPath: string): string {
        this.dirPath = null!;
        if (dirPath) {
            dirPath = dirPath.replace(/^\s*|\s*$/g, "");
            if (dirPath) {
                const stat = this.stat(dirPath);
                if (stat) {
                    if (stat.isDirectory()) {
                        this.dirPath = this.normalizeDirPath(dirPath);
                        return "";
                    }
                    return "不是目录：" + dirPath;
                }
                return "找不到文件：" + dirPath;
            }
        }
        return "未指定目录";
    }

    public 把所有子文件夹里的文件提到主文件夹里并删除子文件夹(dirPath: string): void {
        if (this.isDir(dirPath)) {
            dirPath = this.normalizeDirPath(dirPath);
            for (const filePath of this.getFilePaths(dirPath, true)) {
                const matchArr = filePath.match(/^(.+\/)([^\/]+)$/)!;
                if (matchArr[1] == dirPath) { } else {
                    this.cutFile(filePath, dirPath + matchArr[2]);
                }
            }
            for (const subDirPath of this.getDirPaths(dirPath, false)) {
                this.rmdir(subDirPath);
            }
        } else {
            console.error("无 " + dirPath);
        }
    }
}