export default new class {
    public appDirPath!: string;
    public exesPath!: string;
    public templatesPath!: string;
    public successMsg!: (msg: string) => void;
    public successHTML!: (html: string) => void;
    public errMsg!: (msg: string) => void;
    public showLoading!: (info: string) => void;
    public hideLoading!: () => void;
    public readClipboard!: () => string;
    public writeClipboard!: (content: string) => void;
    public init(): void {
        this.appDirPath = (window as any).ShellUtils.appDirPath;
        this.exesPath = this.appDirPath + "exes/";
        this.templatesPath = this.appDirPath + "各种模板/";
        this.successMsg = (window as any).ShellUtils.successMsg;
        this.successHTML = (window as any).ShellUtils.successHTML;
        this.errMsg = (window as any).ShellUtils.errMsg;
        this.showLoading = (window as any).ShellUtils.showLoading;
        this.hideLoading = (window as any).ShellUtils.hideLoading;
        this.readClipboard = (window as any).ShellUtils.readClipboard;
        this.writeClipboard = (window as any).ShellUtils.writeClipboard;
        console.log(
            "appDirPath=" + this.appDirPath + "\n" +
            "exesPath=" + this.exesPath + "\n" +
            "appDirPath=" + this.templatesPath
        );
    }
    public clearObj<T>(obj: T): void {
        for (const key in obj) {
            delete obj[key];
        }
    }
    public deepCopy<T>(obj: T): T {
        return this.tryParse<T>(this.tryStringify(obj));
    }
    public tryStringify(value: any, replacer?: (this: any, key: string, value: any) => any, space?: string | number): string {
        try {
            return JSON.stringify(value, replacer, space);
        } catch (e) {
            console.error(e);
        }
        return "";
    }
    public tryParse<T>(jsonCode: string): T {
        if (jsonCode) {
            try {
                return JSON.parse(jsonCode);
            } catch (e) {
                console.error(e + "\n" + jsonCode);
            }
        }
        return null!;
    }

    public delay(ms: number) {
        return new Promise(re => { setTimeout(re, ms) });
    }
    public async checkFinish(check: () => boolean) {
        for (; ;) {
            await this.delay(100);
            if (check()) return;
        }
    }
    public 如果太长了加省略号(str: string, max: number): string {
        if (str) {
            return str.length > max ? str.substr(0, max) + "..." : str;
        }
        return "";
    }
    public 百分数(value: number): string {
        //return Math.round(value * 10000) / 100 + "%";//sometimes no good
        const str = (value * 100).toFixed(2);
        return (str.includes(".") ? str.replace(/(?:\.0+|0+)$/, "") : str) + "%";
    }
}