export default new class {
    public gen(): string {// fc991dd7-0033-4b80-9d41-c8a86a702e59
        return v4();
    }

    //C:\ProgramData\cocos\editors\Creator\2.4.13\resources\engine\cocos2d\core\utils\decode-uuid.js
    private BASE64_KEYS = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=';
    private BASE64_VALUES = new Array(123); // max char code in base64Keys
    private HexChars = '0123456789abcdef';
    private UuidTemplate: string[];
    private Indices: Array<number>;
    // console.log("Indices=" + Indices);//0,1,2,3,4,5,6,7,9,10,11,12,14,15,16,17,19,20,21,22,24,25,26,27,28,29,30,31,32,33,34,35
    private indicesLen: number;
    public constructor() {
        const _t = ['', '', '', ''];
        this.UuidTemplate = _t.concat(_t, '-', _t, '-', _t, '-', _t, '-', _t, _t, _t);
        this.Indices = this.UuidTemplate.map(function (x, i) { return x === '-' ? NaN : i; }).filter(isFinite);
        this.indicesLen = this.Indices.length;
        for (let i = 0; i < 123; ++i) this.BASE64_VALUES[i] = 64; // fill with placeholder('=') index
        for (let i = 0; i < 64; ++i) this.BASE64_VALUES[this.BASE64_KEYS.charCodeAt(i)] = i;
        let i: number = 0;
        for (const c of this.HexChars) {
            this.hexValues[c] = i++;
        }
    }
    public decode(base64: string): string {// fcmR3XADNLgJ1ByKhqcC5Z -> fc991dd7-0033-4b80-9d41-c8a86a702e59
        this.UuidTemplate[0] = base64[0]!;
        this.UuidTemplate[1] = base64[1]!;
        for (let i = 2, j = 2; i < 22; i += 2) {
            let lhs = this.BASE64_VALUES[base64.charCodeAt(i)];
            let rhs = this.BASE64_VALUES[base64.charCodeAt(i + 1)];
            this.UuidTemplate[this.Indices[j++]!] = this.HexChars[lhs >> 2]!;
            this.UuidTemplate[this.Indices[j++]!] = this.HexChars[((lhs & 3) << 2) | rhs >> 4]!;
            this.UuidTemplate[this.Indices[j++]!] = this.HexChars[rhs & 0xF]!;
        }
        return this.UuidTemplate.join('');
    }

    private base64: string[] = [];
    private hexValues: { [key: string]: number } = {};
    public encode(uuid: string): string {// fc991dd7-0033-4b80-9d41-c8a86a702e59 -> fcmR3XADNLgJ1ByKhqcC5Z
        this.base64[0] = uuid[0]!;
        this.base64[1] = uuid[1]!;
        let i: number = 2;
        let j: number = 2;
        while (i < this.indicesLen) {
            const num = this.hexValues[uuid[this.Indices[i++]!]!]! << 8 | this.hexValues[uuid[this.Indices[i++]!]!]! << 4 | this.hexValues[uuid[this.Indices[i++]!]!]!;
            this.base64[j++] = this.BASE64_KEYS[num >> 6]!;
            this.base64[j++] = this.BASE64_KEYS[num & 0x3f]!;
        }
        return this.base64.join("");
    }

    public getUUIDs(code: string): string[] {
        const uuids: string[] = [];
        const matchArr = code.match(/\b_*uuid_*\b\W*[\da-f\-]+/g);
        if (matchArr) {
            for (const str of matchArr) {
                const uuid = str.match(/[\da-f\-]+$/)![0];
                uuids.includes(uuid) || uuids.push(uuid);
            }
        }
        return uuids;
    }

    public getGUIDs(code: string):string[]{
        const guids: string[] = [];
        const matchArr = code.match(/\b_?guid: [\dA-Za-z+/=]{32,}/g);
        if (matchArr) {
            for (const str of matchArr) {
                const guid = str.match(/[\dA-Za-z+/=]{32,}$/)![0];
                guids.includes(guid) || guids.push(guid);
            }
        }
        return guids;
    }
}