export default new class {//微信小游戏不支持 TextEncoder
    private sb: Array<string> = [];
    public encode(str: string): Uint8Array {
        if (str) {
            str = unescape(encodeURIComponent(str));
            let i: number = str.length;
            const bytes = new Uint8Array(i);
            while (i--) {
                bytes[i] = str.charCodeAt(i);
            }
            return bytes;
        }
        return new Uint8Array();
    }

    public decode(bytes: Uint8Array | Array<number>, offset: number = 0, len: number = -1): string {
        offset > 0 || (offset = 0);
        len > -1 || (len = bytes.length);
        this.sb.length = 0;
        while (len--) {
            this.sb[len] = String.fromCharCode(bytes[offset + len]!);
        }
        try {
            return decodeURIComponent(escape(this.sb.join("")));
        } catch (e) {
            console.error(e);
        }
        return undefined!;
    }
}