import { TSUPArgs } from "./Store";
import files from "./files";

export default new class {
    public async build(args: TSUPArgs): Promise<string> {
        args.entry = files.normalizeFilePath(args.entry);
        if (files.isFile(args.entry)) { } else {
            return "无 " + args.entry;
        }
        if (args.outDir) {
            args.outDir = files.normalizeDirPath(args.outDir);
        } else {
            args.outDir = args.entry.replace(/[^\/]+$/, "dist/");
        }
        if (args.tsconfig) {
            args.tsconfig = files.normalizeFilePath(args.tsconfig);
            if (files.isFile(args.tsconfig)) { } else {
                return "无 " + args.tsconfig;
            }
        } else {
            args.tsconfig = args.entry.replace(/[^\/]+$/, "tsconfig.json");
            if (files.isFile(args.tsconfig)) { } else {
                args.tsconfig = undefined!;
            }
        }
        const options: tsupOptions = {
            entry: [args.entry],
            outDir: args.outDir,
            format: args.format
        } as any;
        if (args.tsconfig) {
            options.tsconfig = args.tsconfig;
        }
        if (args.minify) {
            options.minify = args.minify;
        }
        if (args.clean) {
            options.clean = args.clean;
        }
        if (args.es5) {
            options.target = "es5";
        }
        let failReason: string = undefined!;
        let lastTime: number = new Date().getTime() - 1;
        let lastModifyFilePath: string = undefined!;
        await tsup.build(options).catch(reason => {
            failReason = reason;
        });
        if (failReason) {
            return failReason;
        }
        for (const filePath of files.getFilePaths(args.outDir, false)) {
            const stats = files.stat(filePath);
            if (stats) {
                const time = stats.mtime.getTime();
                if (time > lastTime) {
                    lastTime = time;
                    lastModifyFilePath = filePath;
                }
            }
        }
        if (lastModifyFilePath) {
            args.result = lastModifyFilePath;
            return undefined!;
        }
        return "无输出文件！";
    }
}