import Utils from "./Utils";
import files from "./files";

abstract class _Store {
    private savePath!: string;
    private keys!: Array<string>;
    private defaultValues!: { [key: string]: any };
    private values!: { [key: string]: any };
    public init(savePath: string): void {
        files.mkParentDir(this.savePath = savePath);
        this.keys = [];
        this.defaultValues = {};
        this.values = {};
        for (const key in this) {
            switch (key) {
                case "savePath":
                case "keys":
                case "defaultValues":
                case "values":
                    break;
                default:
                    switch (typeof this[key]) {
                        case "boolean":
                        case "number":
                        case "string":
                            this.keys.push(key);
                            this.defaultValues[key] = this[key];
                            break;
                        case "object":
                            this.keys.push(key);
                            this.defaultValues[key] = Utils.deepCopy(this[key]);
                            break;
                        default:
                            break;
                    }
                    break;
            }
        }

        if (files.isFile(this.savePath)) {
            const jsonCode = files.readStr(this.savePath);
            //console.log(this.savePath + "\n" + jsonCode);
            const json = Utils.tryParse<any>(jsonCode);
            if (json) {
                for (const key in json) {
                    (this as any)[key] = json[key];
                }
            }
        }
    }
    public reset(): void {
        for (const key of this.keys) {
            switch (typeof this.defaultValues[key]) {
                case "boolean":
                case "number":
                case "string":
                    (this as any)[key] = this.defaultValues[key];
                    break;
                case "object":
                    (this as any)[key] = Utils.deepCopy(this.defaultValues[key]);
                    break;
                default:
                    break;
            }
        }
    }
    public flush(): void {
        for (const key of this.keys) {
            this.values[key] = (this as any)[key];
        }
        const jsonCode = Utils.tryStringify(this.values, undefined, "\t");
        files.writeStr(this.savePath, jsonCode);
    }
}

export interface PageInfo {
    str: string;
    dir: string;
}
export interface AESInfo extends PageInfo {
    key: string;
    iv: string;
}
export interface PathDir {
    path: string;
    dir: string;
}
export interface DirDir {
    dir: string;
    dir2: string;
}
export interface TSUPArgs {
    entry: string,
    outDir: string,
    tsconfig: string,
    minify: boolean,
    clean: boolean,
    format: 'cjs' | 'esm' | 'iife',
    es5: boolean,
    result: string
}
export interface RenameArgs {
    dir: string;
    mode: "编号" | "正则";
    prefix: string;
    编号位数: number;
    reg: string;
    replace: string;
    type: "文件" | "目录";
}
export interface PNG24Args {
    dir: string;
    调整尺寸: "无" | "限宽" | "限高" | "百分比";
    wh: number;
    p: number;
    去掉周围空白: boolean;
}
export interface UglifyArgs {
    jss: string;
    api: "terser" | "uglifyjs";
}
export interface Fixs {
    poj: string;
    处理文件名: {
        启用: boolean;
        去掉空白逗号分号: boolean;
        后缀改小写: boolean;
        jpeg改jpg: boolean;
    },
    处理PNG: {
        启用: boolean;
        去掉周围空白: boolean;
        再存: boolean;
    },
    处理文本: {
        启用: boolean;
        存成UTF8: boolean;
    },
    处理纹理: {
        启用: boolean;
        packable: "不处理" | "true" | "false";
        premultiplyAlpha: "不处理" | "true" | "false";
        trimType: "不处理" | "auto" | "custom" | "none";
    },
    处理自动图集: {
        启用: boolean;
        宽: number;
        高: number;
        间距: number;
        旋转: "不处理" | "true" | "false";
        正方形: "不处理" | "true" | "false";
        二次幂: "不处理" | "true" | "false";
        扩边: "不处理" | "true" | "false";
    },
    处理预制体: {
        启用: boolean;
        名字: boolean;
        premultiplyAlpha: "不处理" | "true" | "false";
    }
    跨bundle引用: boolean;
}
export interface 拼音Args {
    str: string;
    style: "带声调" | "不带声调" | "首字母"
}
export default new class extends _Store {
    public pageName: string = "";
    public 生成图标: PathDir = { path: "", dir: "" };
    public 批量重命名: RenameArgs = { dir: "", mode: "编号", prefix: "无名", 编号位数: 2, reg: "^(.*?)(\\.\\w+)?$", replace: "$1{n}$2", type: "文件" };
    public CRC32: PageInfo = { str: "123abc人口手壹隻臺灣憂鬱烏龜📅💩👨‍👩‍👦‍👦🤦🏻‍♂️🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)", dir: "" };
    public MD5: PageInfo = { str: "123abc人口手壹隻臺灣憂鬱烏龜📅💩👨‍👩‍👦‍👦🤦🏻‍♂️🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)", dir: "" };
    public SHA256: PageInfo = { str: "123abc人口手壹隻臺灣憂鬱烏龜📅💩👨‍👩‍👦‍👦🤦🏻‍♂️🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)", dir: "" };
    public Base64: PageInfo = { str: "123abc人口手壹隻臺灣憂鬱烏龜📅💩👨‍👩‍👦‍👦🤦🏻‍♂️🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)", dir: "" };
    public AES: AESInfo = { str: "123abc人口手壹隻臺灣憂鬱烏龜📅💩👨‍👩‍👦‍👦🤦🏻‍♂️🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)", key: "you jump, i jump", iv: "~~隻臺烏龜~~", dir: "" };
    public TSUP: TSUPArgs = {} as any;
    public PNG24: PNG24Args = { 去掉周围空白: false, dir: "", 调整尺寸: "无", wh: 250, p: 1 };
    public PNG8: PathDir = { path: "", dir: "" };
    public ASTC: PathDir = { path: "", dir: "" };
    public DDS: PathDir = { path: "", dir: "" };
    public BMFont: DirDir = { dir: "", dir2: "未指定" };
    public 大整数: PageInfo = { str: "", dir: "" };
    public 转UTF8: PageInfo = { str: ".ts,.js,.json,.cs,.java", dir: "" };
    public 物理盘序列号: PathDir = { path: "", dir: "" };
    public ZIP: PathDir = { path: "", dir: "" };
    public BR: PathDir = { path: "", dir: "" };
    public LZ4: PathDir = { path: "", dir: "" };
    public 丑化美化JS: UglifyArgs = { jss: "", api: "terser" };
    public 批量修正: Fixs = {} as any;
    public Excel转JSON: PathDir = { path: "", dir: "" };
    public 拼音: 拼音Args = { str: "123abc人口手壹隻臺灣憂鬱烏龜📅💩👨‍👩‍👦‍👦🤦🏻‍♂️🗡️1༆苍༒白2乄3人🈳😊☜🐟口🐳手Ϩ蚠䉀隀쨀☻☺🐠⭐ლ(′◉❥◉｀ლ)", style: "带声调" };
}