export default new class {
    public async fromFile(imgPath: string): Promise<{ img: sharp.Sharp, wid: number, hei: number, failReason: string }> {
        const img = sharp(imgPath);
        const result = { img: img, wid: 0, hei: 0, failReason: "" };
        if (img) {
            const metadata = await img.metadata().catch(reason => {
                result.failReason = "获取图片信息失败：" + reason + "\n" + imgPath;
            });
            if (result.failReason) { }
            else if (metadata) {
                result.wid = metadata.width;
                result.hei = metadata.height;
            } else {
                result.failReason = "获取图片信息失败：" + imgPath;
            }
        } else {
            result.failReason = "解析图片失败：" + imgPath;
        }
        return result;
    }
    public async getRGBAs(img: sharp.Sharp) {
        img.ensureAlpha();
        img.toColourspace("srgb");
        return await img.raw().toBuffer();
    }
    public fromRGBAs(rgbas: Buffer, wid: number, hei: number): sharp.Sharp {
        return sharp(rgbas, {
            raw: {
                width: wid,
                height: hei,
                channels: 4
            }
        });
    }
    public getEmptyRGBAs(w: number, h: number): Buffer {
        return Buffer.alloc(w * h * 4);
    }
    public fillRect(srcRGBAs: Uint8Array, srcWid: number, fillX: number, fillY: number, fillW: number, fillH: number, fillR: number = 0, fillG: number = 0, fillB: number = 0, fillA: number = 0): void {
        for (let y: number = 0; y < fillH; y++) {
            const offset = (fillY + y) * srcWid + fillX;
            for (let x: number = 0; x < fillW; x++) {
                const i = offset + x << 2;
                srcRGBAs[i] = fillR;
                srcRGBAs[i + 1] = fillG;
                srcRGBAs[i + 2] = fillB;
                srcRGBAs[i + 3] = fillA;
            }
        }
    }
    public copy(srcRGBAs: Uint8Array, srcWid: number, srcX: number, srcY: number, destRGBAs: Uint8Array, destWid: number, destX: number, destY: number, w: number, h: number): void {
        for (let y: number = 0; y < h; y++) {
            const offsetI = (srcY + y) * srcWid + srcX;
            const offsetJ = (destY + y) * destWid + destX;
            for (let x: number = 0; x < w; x++) {
                const i = offsetI + x << 2;
                const j = offsetJ + x << 2;
                destRGBAs[j] = srcRGBAs[i]!;
                destRGBAs[j + 1] = srcRGBAs[i + 1]!;
                destRGBAs[j + 2] = srcRGBAs[i + 2]!;
                destRGBAs[j + 3] = srcRGBAs[i + 3]!;
            }
        }
    }
    public 获取有效区域(rgbas: Buffer, wid: number, hei: number): { full: boolean, l: number, t: number, r: number, b: number } {
        let l: number = wid;
        let r: number = -1;
        let t: number = hei;
        let b: number = -1;
        let i: number = 0;
        for (let y: number = 0; y < hei; y++) {
            for (let x: number = 0; x < wid; x++) {
                const a = rgbas[i + 3];
                if (a) {
                    x < l && (l = x);
                    x > r && (r = x);
                    y < t && (t = y);
                    y > b && (b = y);
                }
                i += 4;
            }
        }
        if (r > -1) return { full: l == 0 && r == wid - 1 && t == 0 && b == hei - 1, l: l, t: t, r: r, b: b };
        return undefined!;//全透明
    }
}