import Utils from "./Utils";
import files from "./files";

export default new class {
    public init(): void {
        files.clearOrMakeDir(Utils.appDirPath + "screenshots/");
    }
    public test(): void {
        for (const monitor of screenshot.Monitor.all()) {
            console.log(monitor);
            // Monitor {id: 65594, name: '\\\\.\\DISPLAY5', x: 0, y: 0, width: 1920, …}
            // Monitor {id: 262145, name: '\\\\.\\DISPLAY1', x: 1920, y: 0, width: 1920, …}
            const image = monitor.captureImageSync();
            files.checkAndWrite(Utils.appDirPath + "screenshots/monitor" + monitor.id + ".png", image.toPngSync());
        }
        for (const window of screenshot.Window.all()) {
            console.log(window);
            // Window {id: 65884, appName: 'Windows 资源管理器', title: '', currentMonitor: Monitor, x: 0, …}
            // Window {id: 199710, appName: 'Electron', title: '工具集', currentMonitor: Monitor, x: 1920, …}
            // Window {id: 199678, appName: 'LLKNew.exe', title: '连连看翻新版', currentMonitor: Monitor, x: 320, …}
            // Window {id: 199720, appName: 'Windows 命令处理程序', title: 'Administrator:  C:\\Windows\\system32\\cmd.exe ', currentMonitor: Monitor, x: 104, …}
            // Window {id: 131782, appName: 'Windows 资源管理器', title: 'eltool', currentMonitor: Monitor, x: 1962, …}
            // Window {id: 721622, appName: 'QQ游戏', title: '连连看翻新版', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 1247278, appName: 'QQ游戏', title: '连连看', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 527292, appName: 'QQ游戏', title: 'QQ游戏', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 68210, appName: 'Unity Editor', title: 'Administrator: WDQK - Test - Windows, Mac, Linux - Unity 2023.2.17f1c1 <DX11>', currentMonitor: Monitor, x: 1912, …}
            // Window {id: 657116, appName: 'Google Chrome', title: '合成打僵尸总表.xlsx - 飞书云文档 - Google Chrome', currentMonitor: Monitor, x: 1912, …}
            // Window {id: 265892, appName: 'Windows 资源管理器', title: '1st', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 921158, appName: 'Windows 资源管理器', title: 'ui', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 394824, appName: 'Sourcetree', title: 'Sourcetree', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 67842, appName: 'Visual Studio Code', title: 'screenshots.ts - eltool - Visual Studio Code [管理员]', currentMonitor: Monitor, x: -32000, …}
            // Window {id: 133350, appName: 'CocosCreator', title: 'Cocos Creator - hcdjs - db://assets/1st/Main.prefab', currentMonitor: Monitor, x: -32000, …}
            const image = window.captureImageSync();
            files.checkAndWrite(Utils.appDirPath + "screenshots/window" + window.id + ".png", image.toPngSync());
        }
    }
    public failReason!: string;
    public window!: screenshot.Window;
    public findWindow(appName: string, title?: string): void {
        this.failReason = undefined!;
        this.window = undefined!;
        if (appName) {
            let nameLower: string = appName.replace(/^\s*|\s*$/g, "");
            if (nameLower) {
                nameLower = nameLower.toLowerCase();
                const titleLower = title?.toLowerCase() || title;
                for (const window of screenshot.Window.all()) {
                    if (window.appName.toLowerCase().includes(nameLower)) {
                        if (titleLower) {
                            if (window.title.toLowerCase().includes(titleLower)) {
                                this.window = window;
                                return;
                            }
                        } else {
                            this.window = window;
                            return;
                        }
                    }
                }
                this.failReason = "未找到窗口：" + appName + "！";
                return;
            }
        }
        this.failReason = "未指定窗口名称！";
    }
    public shotWindow(appName: string, title?: string): string {
        this.findWindow(appName, title);
        if (this.failReason) return undefined!;
        const image = this.window.captureImageSync();
        const pngPath = Utils.appDirPath + "screenshots/window" + this.window.id + ".png";
        files.checkAndWrite(pngPath, image.toPngSync());
        return pngPath;
    }
}