import Hex from "./Hex";
import UTF8 from "./UTF8";

export default new class {
    private k: Uint32Array = new Uint32Array([0x428A2F98, 0x71374491, 0xB5C0FBCF, 0xE9B5DBA5, 0x3956C25B, 0x59F111F1, 0x923F82A4, 0xAB1C5ED5, 0xD807AA98, 0x12835B01, 0x243185BE, 0x550C7DC3, 0x72BE5D74, 0x80DEB1FE, 0x9BDC06A7, 0xC19BF174, 0xE49B69C1, 0xEFBE4786, 0xFC19DC6, 0x240CA1CC, 0x2DE92C6F, 0x4A7484AA, 0x5CB0A9DC, 0x76F988DA, 0x983E5152, 0xA831C66D, 0xB00327C8, 0xBF597FC7, 0xC6E00BF3, 0xD5A79147, 0x6CA6351, 0x14292967, 0x27B70A85, 0x2E1B2138, 0x4D2C6DFC, 0x53380D13, 0x650A7354, 0x766A0ABB, 0x81C2C92E, 0x92722C85, 0xA2BFE8A1, 0xA81A664B, 0xC24B8B70, 0xC76C51A3, 0xD192E819, 0xD6990624, 0xF40E3585, 0x106AA070, 0x19A4C116, 0x1E376C08, 0x2748774C, 0x34B0BCB5, 0x391C0CB3, 0x4ED8AA4A, 0x5B9CCA4F, 0x682E6FF3, 0x748F82EE, 0x78A5636F, 0x84C87814, 0x8CC70208, 0x90BEFFFA, 0xA4506CEB, 0xBEF9A3F7, 0xC67178F2]);
    private w: Uint32Array = new Uint32Array(64);
    private t: Uint32Array = new Uint32Array(2);

    private abcdefgh: Uint32Array = new Uint32Array(8);
    private ABCDEFGH: Uint32Array = new Uint32Array(8);

    public sha256(strOrBytes: string | Uint8Array | Array<number>): string {
        const bytes = strOrBytes?.length ? typeof (strOrBytes) == "string" ? UTF8.encode(strOrBytes) : strOrBytes : [];
        let len: number = bytes.length;
        let j: number = ((len << 3) + 64 >> 9) + 1 << 4;
        const words = new Uint32Array(j);
        let i: number = len;
        while (i--) {
            words[i >> 2] |= bytes[i]! << (24 - (i << 3 & 0x1c));
        }
        words[len >> 2] |= 0x80 << 24 - (len << 3 & 0x1c);
        i = j;
        words[i - 1] = len << 3;
        len = i;

        this.abcdefgh[0] = 0x6A09E667;
        this.abcdefgh[1] = 0xBB67AE85;
        this.abcdefgh[2] = 0x3C6EF372;
        this.abcdefgh[3] = 0xA54FF53A;
        this.abcdefgh[4] = 0x510E527F;
        this.abcdefgh[5] = 0x9B05688C;
        this.abcdefgh[6] = 0x1F83D9AB;
        this.abcdefgh[7] = 0x5BE0CD19;
        for (i = 0; i < len; i += 16) {
            this.ABCDEFGH[0] = this.abcdefgh[0];
            this.ABCDEFGH[1] = this.abcdefgh[1];
            this.ABCDEFGH[2] = this.abcdefgh[2];
            this.ABCDEFGH[3] = this.abcdefgh[3];
            this.ABCDEFGH[4] = this.abcdefgh[4];
            this.ABCDEFGH[5] = this.abcdefgh[5];
            this.ABCDEFGH[6] = this.abcdefgh[6];
            this.ABCDEFGH[7] = this.abcdefgh[7];
            for (j = 0; j < 64; j++) {
                if (j < 16) {
                    this.w[j] = words[j + i]!;
                } else {
                    this.w[j] = this.gamma1256(this.w[j - 2]!) + this.w[j - 7]! + this.gamma0256(this.w[j - 15]!) + this.w[j - 16]!;
                }
                this.t[0] = this.abcdefgh[7] + this.sigma1256(this.abcdefgh[4]) + this.ch(this.abcdefgh[4], this.abcdefgh[5], this.abcdefgh[6]) + this.k[j]! + this.w[j]!;
                this.t[1] = this.sigma0256(this.abcdefgh[0]) + this.maj(this.abcdefgh[0], this.abcdefgh[1], this.abcdefgh[2]);
                this.abcdefgh[7] = this.abcdefgh[6];
                this.abcdefgh[6] = this.abcdefgh[5];
                this.abcdefgh[5] = this.abcdefgh[4];
                this.abcdefgh[4] = this.abcdefgh[3] + this.t[0];
                this.abcdefgh[3] = this.abcdefgh[2];
                this.abcdefgh[2] = this.abcdefgh[1];
                this.abcdefgh[1] = this.abcdefgh[0];
                this.abcdefgh[0] = this.t[0] + this.t[1];
            }
            this.abcdefgh[0] += this.ABCDEFGH[0];
            this.abcdefgh[1] += this.ABCDEFGH[1];
            this.abcdefgh[2] += this.ABCDEFGH[2];
            this.abcdefgh[3] += this.ABCDEFGH[3];
            this.abcdefgh[4] += this.ABCDEFGH[4];
            this.abcdefgh[5] += this.ABCDEFGH[5];
            this.abcdefgh[6] += this.ABCDEFGH[6];
            this.abcdefgh[7] += this.ABCDEFGH[7];
        }

        return Hex.ints2str(this.abcdefgh);
    }
    private ch(x: number, y: number, z: number): number { return x & y ^ ~x & z; }
    private maj(x: number, y: number, z: number): number { return x & y ^ x & z ^ y & z; }
    private s(x: number, n: number): number { return x >>> n | x << 32 - n; }
    private r(x: number, n: number): number { return x >>> n; }
    private sigma0256(x: number): number { return this.s(x, 2) ^ this.s(x, 13) ^ this.s(x, 22); }
    private sigma1256(x: number): number { return this.s(x, 6) ^ this.s(x, 11) ^ this.s(x, 25); }
    private gamma0256(x: number): number { return this.s(x, 7) ^ this.s(x, 18) ^ this.r(x, 3); }
    private gamma1256(x: number): number { return this.s(x, 17) ^ this.s(x, 19) ^ this.r(x, 10); }
}