import Sharps from "./Sharps";
import files from "./files";

export default new class {
    public async doo(filePath: string): Promise<string> {
        const sharp = await Sharps.fromFile(filePath);
        if (sharp.failReason) { } else {
            files.writeBytes(filePath, await sharp.img.png({
                palette: true,   // 关键：启用调色板 → PNG-8
                colors: 256,     // 可选 2–256，默认 256
                quality: 90      // 量化质量 0–100，越高体积越大
            }).toBuffer());
        }
        sharp.img?.destroy();
        return sharp.failReason;
    }
}