import Sharps from "./Sharps";
import { PNG24Args } from "./Store";
import files from "./files";

export default new class {
    private args!: PNG24Args;
    public set(args: PNG24Args): void {
        this.args = args;
    }
    public async doo(filePath: string): Promise<string> {
        const sharp = await Sharps.fromFile(filePath);
        if (sharp.failReason) { } else {
            const icon = sharp.img;
            let wid: number = sharp.wid;
            let hei: number = sharp.hei;
            let dw: number;
            let dh: number;
            switch (this.args.调整尺寸) {
                case "限宽":
                    dw = this.args.wh - wid;
                    if (dw < -0.5 || dw > 0.5) {
                        hei = Math.round(hei * this.args.wh / wid);
                        hei > 1 || (hei = 1);
                        wid = Math.round(this.args.wh);
                        wid > 1 || (wid = 1);
                        icon.resize(wid, hei);
                    }
                    break;
                case "限高":
                    dh = this.args.wh - hei;
                    if (dh < -0.5 || dh > 0.5) {
                        wid = Math.round(wid * this.args.wh / hei);
                        wid > 1 || (wid = 1);
                        hei = Math.round(this.args.wh);
                        hei > 1 || (hei = 1);
                        icon.resize(wid, hei);
                    }
                    break;
                case "百分比":
                    const newWid = wid * this.args.p;
                    const newHei = hei * this.args.p;
                    dw = newWid - wid;
                    dh = newHei - hei;
                    if (dw < -0.5 || dw > 0.5 || dh < -0.5 || dh > 0.5) {
                        wid = Math.round(newWid);
                        wid > 1 || (wid = 1);
                        hei = Math.round(newHei);
                        hei > 1 || (hei = 1);
                        icon.resize(wid, hei);
                    }
                    break;
            }
            if (this.args.去掉周围空白) {
                const ltrb = Sharps.获取有效区域(await Sharps.getRGBAs(icon), wid, hei);
                if (ltrb) {
                    ltrb.full || icon.extract({ left: ltrb.l, top: ltrb.t, width: ltrb.r - ltrb.l + 1, height: ltrb.b - ltrb.t + 1 });
                }
            }
            files.writeBytes(filePath, await icon.png().toBuffer());
        }
        sharp.img?.destroy();
        return sharp.failReason;
    }
}