import Hex from "./Hex";
import UTF8 from "./UTF8";

export default new class {
    private s11: number = 7;
    private s12: number = 12;
    private s13: number = 17;
    private s14: number = 22;

    private s21: number = 5;
    private s22: number = 9;
    private s23: number = 14;
    private s24: number = 20;

    private s31: number = 4;
    private s32: number = 11;
    private s33: number = 16;
    private s34: number = 23;

    private s41: number = 6;
    private s42: number = 10;
    private s43: number = 15;
    private s44: number = 21;

    private ABCD: Uint32Array = new Uint32Array(4);
    private abcd: Uint32Array = new Uint32Array(4);

    public md5(strOrBytes: string | Uint8Array | Array<number>): string {
        const bytes = strOrBytes?.length ? typeof (strOrBytes) == "string" ? UTF8.encode(strOrBytes) : strOrBytes : [];
        let len: number = bytes.length;
        let j: number = (len + 8 >> 6) + 1 << 4;
        const words = new Uint32Array(j);
        let i: number = len;
        while (i--) {
            words[i >> 2] |= bytes[i]! << ((i & 0x03) << 3);
        }
        words[len >> 2] |= 0x80 << ((len & 0x03) << 3);
        i = j;
        words[i - 2] = len << 3;
        words[i - 1] = len >>> 29;
        len = i;

        this.abcd[0] = 0x67452301;
        this.abcd[1] = 0xefcdab89;
        this.abcd[2] = 0x98badcfe;
        this.abcd[3] = 0x10325476;
        for (i = 0; i < len; i += 16) {
            this.ABCD[0] = this.abcd[0];
            this.ABCD[1] = this.abcd[1];
            this.ABCD[2] = this.abcd[2];
            this.ABCD[3] = this.abcd[3];

            this.abcd[0] = this.F(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i]!, this.s11, 0xd76aa478);
            this.abcd[3] = this.F(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 1]!, this.s12, 0xe8c7b756);
            this.abcd[2] = this.F(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 2]!, this.s13, 0x242070db);
            this.abcd[1] = this.F(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 3]!, this.s14, 0xc1bdceee);
            this.abcd[0] = this.F(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 4]!, this.s11, 0xf57c0faf);
            this.abcd[3] = this.F(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 5]!, this.s12, 0x4787c62a);
            this.abcd[2] = this.F(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 6]!, this.s13, 0xa8304613);
            this.abcd[1] = this.F(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 7]!, this.s14, 0xfd469501);
            this.abcd[0] = this.F(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 8]!, this.s11, 0x698098d8);
            this.abcd[3] = this.F(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 9]!, this.s12, 0x8b44f7af);
            this.abcd[2] = this.F(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 10]!, this.s13, 0xffff5bb1);
            this.abcd[1] = this.F(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 11]!, this.s14, 0x895cd7be);
            this.abcd[0] = this.F(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 12]!, this.s11, 0x6b901122);
            this.abcd[3] = this.F(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 13]!, this.s12, 0xfd987193);
            this.abcd[2] = this.F(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 14]!, this.s13, 0xa679438e);
            this.abcd[1] = this.F(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 15]!, this.s14, 0x49b40821);

            this.abcd[0] = this.G(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 1]!, this.s21, 0xf61e2562);
            this.abcd[3] = this.G(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 6]!, this.s22, 0xc040b340);
            this.abcd[2] = this.G(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 11]!, this.s23, 0x265e5a51);
            this.abcd[1] = this.G(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i]!, this.s24, 0xe9b6c7aa);
            this.abcd[0] = this.G(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 5]!, this.s21, 0xd62f105d);
            this.abcd[3] = this.G(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 10]!, this.s22, 0x02441453);
            this.abcd[2] = this.G(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 15]!, this.s23, 0xd8a1e681);
            this.abcd[1] = this.G(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 4]!, this.s24, 0xe7d3fbc8);
            this.abcd[0] = this.G(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 9]!, this.s21, 0x21e1cde6);
            this.abcd[3] = this.G(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 14]!, this.s22, 0xc33707d6);
            this.abcd[2] = this.G(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 3]!, this.s23, 0xf4d50d87);
            this.abcd[1] = this.G(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 8]!, this.s24, 0x455a14ed);
            this.abcd[0] = this.G(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 13]!, this.s21, 0xa9e3e905);
            this.abcd[3] = this.G(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 2]!, this.s22, 0xfcefa3f8);
            this.abcd[2] = this.G(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 7]!, this.s23, 0x676f02d9);
            this.abcd[1] = this.G(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 12]!, this.s24, 0x8d2a4c8a);

            this.abcd[0] = this.H(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 5]!, this.s31, 0xfffa3942);
            this.abcd[3] = this.H(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 8]!, this.s32, 0x8771f681);
            this.abcd[2] = this.H(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 11]!, this.s33, 0x6d9d6122);
            this.abcd[1] = this.H(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 14]!, this.s34, 0xfde5380c);
            this.abcd[0] = this.H(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 1]!, this.s31, 0xa4beea44);
            this.abcd[3] = this.H(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 4]!, this.s32, 0x4bdecfa9);
            this.abcd[2] = this.H(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 7]!, this.s33, 0xf6bb4b60);
            this.abcd[1] = this.H(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 10]!, this.s34, 0xbebfbc70);
            this.abcd[0] = this.H(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 13]!, this.s31, 0x289b7ec6);
            this.abcd[3] = this.H(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i]!, this.s32, 0xeaa127fa);
            this.abcd[2] = this.H(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 3]!, this.s33, 0xd4ef3085);
            this.abcd[1] = this.H(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 6]!, this.s34, 0x04881d05);
            this.abcd[0] = this.H(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 9]!, this.s31, 0xd9d4d039);
            this.abcd[3] = this.H(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 12]!, this.s32, 0xe6db99e5);
            this.abcd[2] = this.H(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 15]!, this.s33, 0x1fa27cf8);
            this.abcd[1] = this.H(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 2]!, this.s34, 0xc4ac5665);

            this.abcd[0] = this.I(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i]!, this.s41, 0xf4292244);
            this.abcd[3] = this.I(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 7]!, this.s42, 0x432aff97);
            this.abcd[2] = this.I(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 14]!, this.s43, 0xab9423a7);
            this.abcd[1] = this.I(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 5]!, this.s44, 0xfc93a039);
            this.abcd[0] = this.I(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 12]!, this.s41, 0x655b59c3);
            this.abcd[3] = this.I(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 3]!, this.s42, 0x8f0ccc92);
            this.abcd[2] = this.I(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 10]!, this.s43, 0xffeff47d);
            this.abcd[1] = this.I(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 1]!, this.s44, 0x85845dd1);
            this.abcd[0] = this.I(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 8]!, this.s41, 0x6fa87e4f);
            this.abcd[3] = this.I(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 15]!, this.s42, 0xfe2ce6e0);
            this.abcd[2] = this.I(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 6]!, this.s43, 0xa3014314);
            this.abcd[1] = this.I(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 13]!, this.s44, 0x4e0811a1);
            this.abcd[0] = this.I(this.abcd[0], this.abcd[1], this.abcd[2], this.abcd[3], words[i + 4]!, this.s41, 0xf7537e82);
            this.abcd[3] = this.I(this.abcd[3], this.abcd[0], this.abcd[1], this.abcd[2], words[i + 11]!, this.s42, 0xbd3af235);
            this.abcd[2] = this.I(this.abcd[2], this.abcd[3], this.abcd[0], this.abcd[1], words[i + 2]!, this.s43, 0x2ad7d2bb);
            this.abcd[1] = this.I(this.abcd[1], this.abcd[2], this.abcd[3], this.abcd[0], words[i + 9]!, this.s44, 0xeb86d391);

            this.abcd[0] += this.ABCD[0];
            this.abcd[1] += this.ABCD[1];
            this.abcd[2] += this.ABCD[2];
            this.abcd[3] += this.ABCD[3];
        }

        return Hex.intrevs2str(this.abcd);
    }

    private F(a: number, b: number, c: number, d: number, x: number, s: number, ac: number): number {
        a += (b & c | ~b & d) + x + ac;
        return (a << s | a >>> 32 - s) + b;
    }

    private G(a: number, b: number, c: number, d: number, x: number, s: number, ac: number) {
        a += (b & d | c & ~d) + x + ac;
        return (a << s | a >>> 32 - s) + b;
    }

    private H(a: number, b: number, c: number, d: number, x: number, s: number, ac: number) {
        a += (b ^ c ^ d) + x + ac;
        return (a << s | a >>> 32 - s) + b;
    }

    private I(a: number, b: number, c: number, d: number, x: number, s: number, ac: number) {
        a += (c ^ (b | ~d)) + x + ac;
        return (a << s | a >>> 32 - s) + b;
    }
}