import files from "./files";
export default new class {
    public constructor() {
        (globalThis as any).LZ4 = this;
    }
    public compress(filePathOrBytes: string | Uint8Array): Uint8Array {
        const uncompressedBytes = filePathOrBytes instanceof Uint8Array ? filePathOrBytes : files.readBytes(filePathOrBytes);
        const input = Buffer.from(uncompressedBytes);
        const output = Buffer.alloc(lz4.encodeBound(input.length));
        const compressedSize = lz4.encodeBlockHC(input, output, 12);
        //console.log("lz4 压缩成功：" + uncompressedBytes.length + " -> " + compressedSize);
        return new Uint8Array(output.slice(0, compressedSize));
    }
    public uncompress(filePathOrBytes: string | Uint8Array, uncompressedLen: number): Uint8Array {
        const compressedBytes = filePathOrBytes instanceof Uint8Array ? filePathOrBytes : files.readBytes(filePathOrBytes);
        const uncompressed = Buffer.alloc(uncompressedLen);
        const uncompressedSize = lz4.decodeBlock(Buffer.from(compressedBytes), uncompressed);
        if (uncompressedSize == uncompressedLen) {
            //console.log("lz4 解压成功：" + compressedBytes.length + " -> " + uncompressedLen);
            return new Uint8Array(uncompressed);
        }
        console.error("lz4 解压失败：" + uncompressedSize + " != " + uncompressedLen);
        return undefined!;
    }
}