import CRC32 from "./CRC32"
import files from "./files";

let dirPath: string;
class Mark {
    private dirPath!: string;
    private ext!: string;
    private result!: string;
    public constructor(ext: string) {
        this.ext = ext;
    }
    public init(key: string): void {
        files.mkdir(this.dirPath = dirPath + key + "/");
    }
    public get(filePathOrBytes: string | Uint8Array, subKey: string = ""): string {
        this.result = this.dirPath + subKey + (CRC32.sizex8crc32x8(filePathOrBytes instanceof Uint8Array ? filePathOrBytes : files.readBytes(filePathOrBytes))) + this.ext;
        return files.isFile(this.result) ? this.result : undefined!;
    }
    public mark(filePathOrBytes: string | Uint8Array): void {
        filePathOrBytes instanceof Uint8Array ? files.writeBytes(this.result, filePathOrBytes) : files.copyFile(filePathOrBytes, this.result);
    }
}
class OptimizedPNG {
    private originalPath: string = undefined!;
    private optimizedPath: string = undefined!;
    private ext: string = undefined!;
    private currName: string = undefined!;
    public constructor(ext: string) {
        this.ext = ext;
    }
    public init(key: string): void {
        files.mkdir(this.originalPath = dirPath + key + "/original/");
        files.mkdir(this.optimizedPath = dirPath + key + "/optimized/");
    }
    public get(pngPath: string): string {
        this.currName = CRC32.sizex8crc32x8(files.readBytes(pngPath));
        let result: string = this.originalPath + this.currName + this.ext;
        if (files.isFile(result)) return "original";
        if (files.isFile(result = this.optimizedPath + this.currName + this.ext)) return result;
        return undefined!;
    }
    public mark(optimizedPNGBytes: Uint8Array | "original", pngPath: string): string {
        if (optimizedPNGBytes == "original") {
            files.copyFile(pngPath, this.originalPath + this.currName + this.ext);
            return "original";
        }
        const result = this.optimizedPath + this.currName + this.ext;
        files.writeBytes(result, optimizedPNGBytes);
        return result;
    }
}
export default new class {
    public img2astc!: Mark;
    public img2dxt5!: Mark;
    public optimizedPNG!: OptimizedPNG;

    public init(_dirPath: string): void {
        dirPath = _dirPath;

        this.img2astc = new Mark(".astc");
        this.img2dxt5 = new Mark(".dds");
        this.optimizedPNG = new OptimizedPNG(".png");

        for (const key in this) {
            const obj = this[key];
            if (obj instanceof Mark || obj instanceof OptimizedPNG) {
                obj.init(key);
            }
        }
    }
}