import Utils from "./Utils";
import files from "./files";

export default new class {
    private dirPath!: string;
    public init(dirPath: string): void {
        this.dirPath = dirPath;
    }
    public check(fileOrDirPath: string): boolean {
        let markPath: string;
        if (fileOrDirPath.endsWith("/")) {
            fileOrDirPath = files.normalizeDirPath(fileOrDirPath);
            markPath = fileOrDirPath.replace(/\/+$/, ".json");
        } else {
            fileOrDirPath = files.normalizeFilePath(fileOrDirPath);
            markPath = fileOrDirPath + ".json";
        }
        markPath = this.dirPath + markPath.replace(":", "");
        if (files.isFile(markPath)) { } else return true;
        const sizeAndTimes: string[] = Utils.tryParse(files.readStr(markPath));
        if (files.isDir(fileOrDirPath)) {
            const mark: { [key: string]: true } = {};
            for (const filePath of files.getFilePaths(fileOrDirPath, true)) {
                mark[filePath] = true;
                const index = sizeAndTimes.indexOf(filePath);
                if (index > -1) { } else return true;//新增的文件
                if (this.isChanged(filePath, sizeAndTimes[index + 1]!)) return true;//修改的文件
            }
            let i: number = sizeAndTimes.length;
            while ((i -= 2) >= 0) {
                if (mark[sizeAndTimes[i]!]) { } else return true;//删除的文件
            }
            return false;
        }
        if (files.isFile(fileOrDirPath)) {
            const index = sizeAndTimes.indexOf(fileOrDirPath);
            if (index > -1) { } else return true;
            if (this.isChanged(fileOrDirPath, sizeAndTimes[index + 1]!)) return true;
            return false;
        }
        return true;
    }
    private isChanged(filePath: string, line: string): boolean {
        const stats = files.stat(filePath);
        if (stats) {
            const arr = line.split(" ");
            const size = parseInt(arr[0]!);
            const time = parseInt(arr[1]!);
            if (stats.size == size && stats.mtime.getTime() == time) return false;
            return true;
        }
        return true;
    }
    public mark(fileOrDirPath: string): void {
        let markPath: string;
        if (fileOrDirPath.endsWith("/")) {
            fileOrDirPath = files.normalizeDirPath(fileOrDirPath);
            markPath = fileOrDirPath.replace(/\/+$/, ".json");
        } else {
            fileOrDirPath = files.normalizeFilePath(fileOrDirPath);
            markPath = fileOrDirPath + ".json";
        }
        markPath = this.dirPath + markPath.replace(":", "");
        const sizeAndTimes: string[] = [];
        if (files.isDir(fileOrDirPath)) {
            for (const filePath of files.getFilePaths(fileOrDirPath, true)) {
                const stats = files.stat(filePath)!;
                sizeAndTimes.push(filePath, stats.size + " " + stats.mtime.getTime());
            }
        } else if (files.isFile(fileOrDirPath)) {
            const stats = files.stat(fileOrDirPath)!;
            sizeAndTimes.push(fileOrDirPath, stats.size + " " + stats.mtime.getTime());
        }
        files.mkParentDir(markPath);
        files.writeStr(markPath, Utils.tryStringify(sizeAndTimes, undefined, "\t"));
    }
}