const zeros = [
    "", "0", "00", "000", "0000", "00000", "000000", "0000000", "00000000", "000000000", "0000000000",
    "00000000000", "000000000000", "0000000000000", "00000000000000", "000000000000000", "0000000000000000", "00000000000000000", "000000000000000000", "0000000000000000000", "00000000000000000000",
    "000000000000000000000", "0000000000000000000000", "00000000000000000000000", "000000000000000000000000", "0000000000000000000000000", "00000000000000000000000000", "000000000000000000000000000", "0000000000000000000000000000", "00000000000000000000000000000", "000000000000000000000000000000",
    "0000000000000000000000000000000", "00000000000000000000000000000000"
];
// const radixs = "0123456789abcdefghijklmnopqrstuvwxyz";
const decimals: Array<number> = [];
const sb: Array<string> = [];
// const mulTable = new Uint16Array(0x10000);
// for (let left: number = 0; left < 0x100; left++) {
//     for (let right: number = 0; right < 0x100; right++) {
//         mulTable[left << 8 | right] = left * right;
//     }
// }
export default class BigInt {
    private shorts!: Uint16Array;//按无符号16位整数存，低位在前，高位在后，比如 0xabcdef，会存成 [0xcdef, 0xab]
    public constructor(input: string | Uint8Array | Array<number> | Uint16Array, offset: number = 0, size: number = 0, rev: boolean = false) {
        let i: number;
        let j: number;
        if (typeof (input) == "string") {
            input = input.replace(/\s+/g, "").toLowerCase();
            if (/^0x[\da-f]+$/.test(input)) {
                input = input.substr(2);
                if (i = (input.length & 0x03)) {
                    input = zeros[4 - i] + input;
                }
                const matchArr: Array<string> = input.match(/[\da-f]{4}/g)!;
                this.shorts = new Uint16Array(i = matchArr.length);
                j = -1;
                while (i--) {
                    this.shorts[++j] = parseInt(matchArr[i]!, 16);
                }
                matchArr.length = 0;
            } else if (/^\d+$/.test(input)) {
                let L: number = input.length;
                this.shorts = new Uint16Array(L / Math.log10(0x10000) + 1 >> 0);
                if (i = L % 11) {
                    input = zeros[11 - i] + input;
                }
                const matchArr: Array<string> = input.match(/\d{11}/g)!;
                i = matchArr.length;
                L = 0;
                while (i--) {
                    decimals[L++] = parseInt(matchArr[i]!);
                }
                matchArr.length = 0;

                let remainder: number;
                let curr: number;
                i = L;
                j = 0;
                while (L) {
                    remainder = 0;
                    while (i--) {
                        curr = remainder * 100000000000 + decimals[i]!;
                        remainder = curr & 0xffff;
                        decimals[i] = (curr - remainder) / 0x10000;
                    }
                    this.shorts[j++] = remainder;

                    i = L;
                    while (decimals[--i] == 0) { }
                    L = ++i;
                }
            } else {
                console.error("input 格式不正确：" + input);
            }
        } else if (input instanceof Uint16Array) {
            offset > 0 || (offset = 0);
            size > 0 || (size = input.length);
            if (rev) {
                this.shorts = new Uint16Array(size);
                i = size;
                j = offset;
                while (i--) {
                    this.shorts[i] = input[j++]!;
                }
            } else {
                this.shorts = input.slice(offset, offset + size);
            }
        } else {
            offset > 0 || (offset = 0);
            size > 0 || (size = input.length);
            this.shorts = new Uint16Array(i = size + 1 >> 1);
            if (size & 0x01) {
                if (rev) {
                    j = offset - 1;
                    while (i--) {
                        this.shorts[i] = input[j++]! << 8 | input[j++]!;
                    }
                } else {
                    j = offset + size + 1;
                    while (i--) {
                        this.shorts[i] = input[--j]! << 8 | input[--j]!;
                    }
                }
                this.shorts[this.shorts.length - 1] &= 0x00ff;
            } else {
                if (rev) {
                    j = offset;
                    while (i--) {
                        this.shorts[i] = input[j++]! << 8 | input[j++]!;
                    }
                } else {
                    j = offset + size;
                    while (i--) {
                        this.shorts[i] = input[--j]! << 8 | input[--j]!;
                    }
                }
            }
        }

        i = this.shorts.length;
        while (this.shorts[--i] == 0) { }
        if (i == -1) {
            this.shorts = new Uint16Array([0]);
        } else if (i == this.shorts.length - 1) { } else {
            this.shorts = this.shorts.slice(0, i + 1);
        }
    }
    public add(right: BigInt): BigInt {
        let l1: number = this.shorts.length;
        let l2: number = right.shorts.length;
        let leftShorts: Uint16Array;
        let rightShorts: Uint16Array;
        if (l1 < l2) {
            const temp = l1;
            l1 = l2;
            l2 = temp;
            leftShorts = right.shorts;
            rightShorts = this.shorts;
        } else {
            leftShorts = this.shorts;
            rightShorts = right.shorts;
        }
        const resultShorts = new Uint16Array(l1 + 1);
        let i: number = -1;
        let curr: number;
        let carry: number = 0;
        while (++i < l2) {
            curr = leftShorts[i]! + rightShorts[i]! + carry;
            resultShorts[i] = curr & 0xffff;
            carry = curr >> 16;
        }
        if (carry) {
            while (i < l1) {
                curr = leftShorts[i]! + carry;
                resultShorts[i] = curr & 0xffff;
                carry = curr >> 16;
                i++;
            }
            resultShorts[i] = carry;
        } else {
            while (i < l1) {
                resultShorts[i] = leftShorts[i++]!;
            }
        }
        return new BigInt(resultShorts);
    }
    public sub(right: BigInt): BigInt {//只支持大的减小的
        const leftShorts = this.shorts;
        const rightShorts = right.shorts;
        const l1 = leftShorts.length;
        const l2 = rightShorts.length;
        const resultShorts = new Uint16Array(l1);
        let i: number = -1;
        let curr: number;
        while (++i < l2) {
            curr = leftShorts[i]! - rightShorts[i]!;
            if (curr < 0) {
                leftShorts[i + 1]--;
                curr += 0x10000;
            }
            resultShorts[i] = curr;
        }
        while (i < l1) {
            resultShorts[i] = leftShorts[i++]!;
        }
        return new BigInt(resultShorts);
    }

    public mul(right: BigInt): BigInt {
        const leftShorts = this.shorts;
        const rightShorts = right.shorts;
        const l1 = leftShorts.length;
        const l2 = rightShorts.length;
        const resultShorts = new Uint16Array(l1 + l2);
        let i: number = -1;
        let j: number;
        let curr: number;
        let carry: number;
        while (++i < l2) {
            const rightShort = rightShorts[i]!;
            j = -1;
            carry = 0;
            while (++j < l1) {
                const leftShort = leftShorts[j]!;
                // curr = resultBytes[i + j] + mulTable[leftByte << 8 | rightByte] + carry;//耗时 4695 毫秒！
                // curr = resultBytes[i + j] + leftByte * rightByte + carry;//耗时 3499 毫秒！
                curr = resultShorts[i + j]! + leftShort * rightShort + carry;//耗时 842 毫秒！
                resultShorts[i + j] = curr & 0xffff;
                carry = curr >>> 16;
            }
            resultShorts[i + j] += carry;
        }
        return new BigInt(resultShorts);
    }
    //https://blog.csdn.net/u010983881/article/details/77503519
    public mulKaratsuba(right: BigInt): BigInt {
        //(100a + b) * (100c + d) = 10000ac + 100(ad + bc) + bd = 10000ac + 100((a+b)(c+d) - ac - bd) + bd
        return BigInt.karatsuba(this, right);
    }
    private static karatsuba(left: BigInt, right: BigInt): BigInt {
        let l1: number = left.shorts.length;
        let l2: number = right.shorts.length;
        if (l1 > 1 && l2 > 1) {
            let leftShorts: Uint16Array;
            let rightShorts: Uint16Array;
            if (l1 < l2) {
                const temp = l1;
                l1 = l2;
                l2 = temp;
                leftShorts = right.shorts;
                rightShorts = left.shorts;
            } else {
                leftShorts = left.shorts;
                rightShorts = right.shorts;
            }
            const m = l1 >> 1;
            const n = l2 >> 1;
            const b = new BigInt(leftShorts, 0, m);
            const a = new BigInt(leftShorts, m, l1 - m);
            const d = new BigInt(rightShorts, 0, n);
            const c = new BigInt(rightShorts, n, l2 - n);
            const ac = this.karatsuba(a, c);
            const bd = this.karatsuba(b, d);
            // (65536ᵐa + b) * (65536ⁿc + d)
            // = 65536ᵐ⁺ⁿac + 65536ᵐad + 65536ⁿbc + bd
            // = 65536ᵐ⁺ⁿac + 65536ᵐ(a + b)d - 65536ᵐbd + 65536ⁿ(a + b)c - 65536ⁿac + bd
            // = 65536ᵐ⁺ⁿac + 65536ⁿ(a + b)(c + 65536ᵐ⁻ⁿd) - 65536ᵐbd - 65536ⁿac + bd
            return ac.moveLeft(m + n).add(this.karatsuba(a.add(b), c.add(d.moveLeft(m - n))).moveLeft(n)).sub(bd.moveLeft(m)).sub(ac.moveLeft(n)).add(bd);
        }
        return left.mul(right);
    }
    public moveLeft(n: number): BigInt {
        const shorts = new Uint16Array(this.shorts.length + n);
        shorts.set(this.shorts, n);
        return new BigInt(shorts);
    }

    public toString(radix: number = 10): string {
        radix >>>= 0;
        if (radix > 1 && radix < 37) { } else {
            console.error("radix 必须大于1且小于37");
            return "";
        }
        let i: number;
        let part: string;
        sb.length = 0;
        let sbIndex: number = 0;
        switch (radix) {
            case 2:
                i = this.shorts.length - 1;
                sb[sbIndex++] = this.shorts[i]!.toString(2);
                while (i--) {
                    part = this.shorts[i]!.toString(2);//1~16位
                    sb[sbIndex++] = zeros[16 - part.length] + part;
                }
                break;
            case 16:
                i = this.shorts.length - 1;
                sb[sbIndex++] = this.shorts[i]!.toString(16);
                while (i--) {
                    part = this.shorts[i]!.toString(16);//1~4位
                    sb[sbIndex++] = zeros[4 - part.length] + part;
                }
                break;
            default:
                let _power: number = radix;
                let power: number = undefined!;
                let digits: number = 1;
                while ((_power *= radix) <= 0x10000) {
                    power = _power;
                    digits++;
                }
                const temp = this.shorts.slice();
                let L: number = temp.length;
                let remainder: number;
                let curr: number;
                i = L;
                while (L) {
                    remainder = 0;
                    while (i--) {
                        curr = (remainder << 16) + temp[i]!;
                        remainder = curr % power;
                        temp[i] = (curr - remainder) / power;
                    }

                    i = L;
                    while (temp[--i] == 0) { }
                    L = ++i;

                    part = remainder.toString(radix);
                    if (L) {
                        curr = part.length % digits;
                        curr && (part = zeros[digits - curr] + part);
                    }
                    sb[sbIndex++] = part;
                }
                sb.reverse();
                break;
        }
        return sb.join("");
    }
}

// //#region ab
// const ab =
//     new BigInt("3333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388888888880005444411111111444345341111111111366588888888779990000000000006666666666655555555554444444447777777777111112222223333332299999922223421133333338888888888000544441111111144434534111111111136658888888877999000000000000666666666665555555555444444444777777777711111222222333333229999992222342113333333888888888800054444111111114443453411111111113665888888887799900000000000066666666666555555555544444444477777777771111122222233333322999999222234211333333388");
// //#endregion
// //#region cd
// const cd = new BigInt("102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834102938475612936916349135675786897035634567567896795245047109102381298301732401734173413659138649160123701270136480136401836651736713648176348013074193470183410293847561293691634913567578689703563456756789679524504710910238129830173240173417341365913864916012370127013648013640183665173671364817634801307419347018341029384756129369163491356757868970356345675678967952450471091023812983017324017341734136591386491601237012701364801364018366517367136481763480130741934701834");
// //#endregion

// let startTime: number = new Date().getTime();
// const abcd1 = ab.mul(cd);
// console.log("耗时 " + (new Date().getTime() - startTime) + " 毫秒！");//耗时 913 毫秒！
// startTime = new Date().getTime();
// const abcd2 = ab.mulKaratsuba(cd);
// console.log("耗时 " + (new Date().getTime() - startTime) + " 毫秒！");//耗时 27718 毫秒！
// console.log(abcd1.toString() == abcd2.toString());