import UTF8 from "./UTF8";

export default new class {
    private sb: Array<string> = [];
    private keys: string = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/";
    private cCodes: { [key: string]: number } = {};
    public constructor() {
        let i: number = this.keys.length;
        while (i--) {
            this.cCodes[this.keys[i]!] = i;
        }
    }
    public encode(strOrBytes: string | Uint8Array | Array<number>): string {
        if (strOrBytes?.length) { } else return "";
        const bytes = typeof (strOrBytes) == "string" ? UTF8.encode(strOrBytes) : strOrBytes;

        let restCode1: number = -1;
        let restCode2: number = -1;
        let offset: number = bytes.length;
        switch (offset % 3) {
            case 0:
                break;
            case 1:
                restCode1 = bytes[--offset]!;
                break;
            case 2:
                restCode2 = bytes[--offset]!;
                restCode1 = bytes[--offset]!;
                break;
        }

        let index: number = 0;
        this.sb.length = 0;
        let sbIndex: number = 0;
        while (index < offset) {
            const code1 = bytes[index++]!;
            const code2 = bytes[index++]!;
            const code3 = bytes[index++]!;
            this.sb[sbIndex++] = this.keys[code1 >> 2]!;
            this.sb[sbIndex++] = this.keys[(code1 & 0x03) << 4 | code2 >> 4]!;
            this.sb[sbIndex++] = this.keys[(code2 & 0x0f) << 2 | code3 >> 6]!;
            this.sb[sbIndex++] = this.keys[code3 & 0x3f]!;
        }
        if (restCode2 > -1) {
            this.sb[sbIndex++] = this.keys[restCode1 >> 2]!;
            this.sb[sbIndex++] = this.keys[(restCode1 & 0x03) << 4 | restCode2 >> 4]!;
            this.sb[sbIndex++] = this.keys[(restCode2 & 0x0f) << 2]!;
            this.sb[sbIndex++] = "=";
        } else if (restCode1 > -1) {
            this.sb[sbIndex++] = this.keys[restCode1 >> 2]!;
            this.sb[sbIndex++] = this.keys[(restCode1 & 0x03) << 4]!;
            this.sb[sbIndex++] = "==";
        }

        return this.sb.join("");
    }

   public decode(str: string): string {
        if (str) { } else return "";

        let restCCode1: number = -1;
        let restCCode2: number = -1;
        let restCCode3: number = -1;
        str = str.replace(/\=+\s*$/, "");
        let len: number = str.length;
        let bytes: Uint8Array;
        switch (len % 4) {
            case 2://==
                restCCode2 = this.cCodes[str[--len]!]!;
                restCCode1 = this.cCodes[str[--len]!]!;
                bytes = new Uint8Array((len >> 2) * 3 + 1);
                break;
            case 3://=
                restCCode3 = this.cCodes[str[--len]!]!;
                restCCode2 = this.cCodes[str[--len]!]!;
                restCCode1 = this.cCodes[str[--len]!]!;
                bytes = new Uint8Array((len >> 2) * 3 + 2);
                break;
            default:
                bytes = new Uint8Array((len >> 2) * 3);
                break;
        }

        let offset: number = 0;
        let index: number = 0;
        while (offset < len) {
            const cCode1 = this.cCodes[str[offset++]!]!;
            const cCode2 = this.cCodes[str[offset++]!]!;
            const cCode3 = this.cCodes[str[offset++]!]!;
            const cCode4 = this.cCodes[str[offset++]!]!;
            bytes[index++] = (cCode1 << 2) | (cCode2 >> 4);
            bytes[index++] = ((cCode2 & 0x0f) << 4) | (cCode3 >> 2);
            bytes[index++] = ((cCode3 & 0x03) << 6) | cCode4;
        }
        if (restCCode3 > -1) {
            bytes[index++] = (restCCode1 << 2) | (restCCode2 >> 4);
            bytes[index++] = ((restCCode2 & 0x0f) << 4) | (restCCode3 >> 2);
        } else if (restCCode2 > -1) {
            bytes[index++] = (restCCode1 << 2) | (restCCode2 >> 4);
        }
        return UTF8.decode(bytes);
    }
}