import CMD from "./CMD";
import Sharps from "./Sharps";
import UUIDs from "./UUIDs";
import Utils from "./Utils";
import files from "./files";
import 项目类型, { PojType } from "./项目类型";

interface Conf {
    name: string;
    src: string;
    gen: string;
    dest: string;
    主字体: boolean;
    sb: Array<string>;
    cs: Array<string>;
    uuid: string;
    空白阈值: number;
}
interface Conf0 {
    dest: string;
    扫描主字体: {
        范围: Array<string>;
        排除: Array<string>;
        文件后缀: Array<string>;
    }
}
interface CharInfo {
    x: number;
    y: number;
    w: number;
    h: number;
}
export default new class {
    private bmFontEXEPath!: string;
    private 基本拉丁语95 = "!\"#$%&'()*+,-./0123456789:;<=>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~";
    private type!: PojType;
    private conf0!: Conf0;
    private confs: Array<Conf> = [];
    private confsByUUID: { [key: string]: Conf } = {};
    private fntPaths!: string[];
    private mainSb: Array<string> = [];
    private glyphPaths: { [key: number]: string } = {};
    private guids: { [key: string]: string } = {};
    private txtRegCC38G = /"_string": (".*")[^{}]*"_font": (?:null|\{\s*"__uuid__": "([\da-f\-]+)")[\s\S]*?"_id": "([^"]*)"/g;
    private txtRegCC38 = new RegExp(this.txtRegCC38G.source);
    private txtRegCC24G = /"_N\$string": (".*")[^{}]*"_N\$file": (?:null|\{\s*"__uuid__": "([\da-f\-]+)")/g;
    private txtRegCC24 = new RegExp(this.txtRegCC24G.source);
    private txtRegTJ1G = /_fntAsset: \{fileID: \d+, guid: (\w+).*\s*_sprite: \{fileID:.*\s*_text: (".*")/g;
    private txtRegTJ1 = new RegExp(this.txtRegTJ1G.source);
    private uuidsByFileId: { [key: string]: string } = {};
    private overrideStrss: { [key: string]: Array<string> } = {};
    private mark: { [key: string]: true } = {};
    private sb: string[] = [];
    public init(bmFontEXEPath: string): void {
        this.bmFontEXEPath = CMD.normalizePath(bmFontEXEPath, true);
    }
    public async gen(confsDirPath: string, pojPath: string, pojType: PojType, confPaths: string[], fntPaths: string[]): Promise<string> {
        const conf0Path = confsDirPath + "conf0.json";
        if (files.isFile(conf0Path)) { } else return "无 " + conf0Path;
        this.conf0 = Utils.tryParse(files.readStr(conf0Path));
        if (this.conf0.dest) {
            this.conf0.dest = files.normalizeDirPath(this.conf0.dest);
        } else {
            this.conf0.dest = "";
        }
        files.checkAndWrite(conf0Path, Utils.tryStringify(this.conf0, undefined, "\t"));
        if (pojPath) {
            let i: number = this.conf0.扫描主字体.范围.length;
            while (i--) {
                this.conf0.扫描主字体.范围[i] = pojPath + this.conf0.扫描主字体.范围[i];
            }
            if (this.conf0.扫描主字体.排除) {
                i = this.conf0.扫描主字体.排除.length;
                while (i--) {
                    this.conf0.扫描主字体.排除[i] = pojPath + this.conf0.扫描主字体.排除[i];
                }
            }
        } else {
            this.conf0.扫描主字体.范围 = undefined!;
            this.conf0.扫描主字体.排除 = undefined!;
        }
        if (files.isDir(pojPath)) {
            if (pojType) {
                this.type = pojType;
            } else {
                return "未知项目类型！";
            }
        } else {
            pojPath = undefined!;
            this.type = "cc24";
        }
        this.confs.length = 0;
        Utils.clearObj(this.confsByUUID);
        switch (this.type) {
            // case "cc24":
            // case "cc38":
            case "tj1":
                Utils.clearObj(this.guids);
                // const commandResultPath = tempFiles.getFilePath(".json");
                // let err: string = Utils.tjCommand(projectConf, "collect guids", {
                //     s1: commandResultPath
                // });
                // if (err) {
                //     console.error(err);
                // } else {
                //     Utils.showLoading("搜集 guid 中……");
                //     let msg: string = undefined!;
                //     ChangeFiles.on(commandResultPath, () => {
                //         ChangeFiles.off(commandResultPath);
                //         const commandResult = Utils.tryParse<{ Status: number, Desc: string, guidsPath: string }>(files.readStr(commandResultPath));
                //         if (commandResult.Status === 0) {
                //             msg = commandResult.Desc;
                //             for (const line of files.readStr(projectConf.poj.root + commandResult.guidsPath).split("\n")) {
                //                 const matchArr = line.match(/^(\w+) (\S+) (.+)$/);
                //                 if (matchArr) {
                //                     this.guids[matchArr[2]!] = matchArr[1]!;
                //                 } else {
                //                     console.error("匹配失败：" + line);
                //                 }
                //             }
                //         } else {
                //             err = commandResult.Desc;
                //         }
                //     });
                //     while (!(msg || err)) {
                //         await Utils.delay(100);
                //     }
                //     Utils.hideLoading();
                // }
                break;
        }
        this.fntPaths = fntPaths;
        for (const confPath of files.getFilePaths(confsDirPath, true, "/conf.json")) {
            confPaths.push(confPath);
            const conf = Utils.tryParse<Conf>(files.readStr(confPath));
            const src = confPath.replace(/[^\/]+$/, "");
            const name = src.match(/([^\/]+)\/$/)![1]!;
            conf.dest = typeof (conf.dest) == "string" ? files.normalizeDirPath(conf.dest) : null!;
            conf.主字体 || (conf.主字体 = false);
            const dest = files.baseDir(pojPath || confsDirPath, conf.dest == null ? this.conf0.dest : conf.dest);
            const fntMetaPath = dest + name + ".fnt.meta";
            //console.log(fntMetaPath);
            if (files.isFile(fntMetaPath)) {
                const fntCode = files.readStr(fntMetaPath);
                switch (this.type) {
                    case "cc24":
                    case "cc38":
                        conf.uuid = UUIDs.getUUIDs(fntCode)[0]!;
                        break;
                    case "tj1":
                        conf.uuid = UUIDs.getGUIDs(fntCode)[0]!;
                        this.guids[conf.uuid] && (conf.uuid = this.guids[conf.uuid]!);
                        break;
                }
            } else {
                delete (conf as any).uuid;
            }
            files.checkAndWrite(confPath, Utils.tryStringify(conf, undefined, "\t"));
            conf.src = src;
            conf.name = name;
            conf.gen = conf.src + "gen/";
            conf.dest = dest;
            conf.sb = [];
            conf.cs = [];
            this.confs.push(conf);
            conf.uuid && (this.confsByUUID[conf.uuid] = conf);
        }
        if (this.confs.length) { } else return "无 confs";
        // console.log(Utils.tryStringify(confs, undefined, "\t"));

        switch (this.type) {
            // case "cc24":
            case "cc38":
                // case "tj1":
                Utils.clearObj(this.uuidsByFileId);
                Utils.clearObj(this.overrideStrss);
                break;
        }
        this.mainSb.length = 0;
        this.mainSb.push(this.基本拉丁语95);
        if (this.conf0.扫描主字体.范围) {
            for (const dirOrPattern of this.conf0.扫描主字体.范围) {
                if (dirOrPattern.endsWith("/")) {
                    if (files.isDir(dirOrPattern)) {
                        for (const filePath of files.getFilePaths(dirOrPattern, true, ...this.conf0.扫描主字体.文件后缀)) {
                            this.collectCs(filePath);
                        }
                    } else {
                        console.error("找不到目录：" + dirOrPattern);
                    }
                } else {
                    const matchArr = dirOrPattern.match(/^(.+)\*(\.\w+)$/);
                    if (matchArr) {
                        const dirPath = matchArr[1]!;
                        if (files.isDir(dirPath)) {
                            for (const filePath of files.getFilePaths(dirPath, true, matchArr[2]!)) {
                                this.collectCs(filePath);
                            }
                        } else {
                            console.error("找不到目录：" + dirPath);
                        }
                    } else {
                        if (files.isFile(dirOrPattern)) {
                            this.collectCs(dirOrPattern);
                        } else {
                            console.error("找不到文件：" + dirOrPattern);
                        }
                    }
                }
            }
        }
        switch (this.type) {
            // case "cc24":
            case "cc38":
                // case "tj1":
                console.log(Utils.tryStringify(this.uuidsByFileId, undefined, "\t"));
                // {
                //     "2cKTv57G9KSr/3NWv3oInI": "9db9d8ec-1050-46b7-a599-18395fe7a8af",
                //     "1fz8w9RxpGmriISoJr6aCz": "9db9d8ec-1050-46b7-a599-18395fe7a8af"
                // }
                console.log(Utils.tryStringify(this.overrideStrss, undefined, "\t"));
                // {
                //     "2cKTv57G9KSr/3NWv3oInI": [
                //         "￥ 666"
                //     ],
                //     "1fz8w9RxpGmriISoJr6aCz": [
                //         "醄 233"
                //     ]
                // }
                for (const fileId in this.uuidsByFileId) {
                    const overrideStrs = this.overrideStrss[fileId];
                    if (overrideStrs) {
                        const uuid = this.uuidsByFileId[fileId]!;
                        const conf = this.confsByUUID[uuid];
                        if (conf) {
                            conf.sb.push.apply(conf.sb, overrideStrs);
                        } else {
                            console.error("无对应的 conf：" + fileId + " " + uuid);
                        }
                    }
                }
                break;
        }

        CMD.standBy();
        Utils.showLoading("切割字体中……");
        let bmfcCode: string;
        for (const conf of this.confs) {
            files.clearOrMakeDir(conf.gen);
            conf.主字体 && (conf.sb.push.apply(conf.sb, this.mainSb));
            const bmfcPath = conf.src + "conf.bmfc";
            if (files.isFile(bmfcPath)) {
                bmfcCode = files.readStr(bmfcPath)
            } else {
                bmfcCode = files.readStr(Utils.templatesPath + "conf.bmfc").replace("{fontName}", conf.name);
            }
            const matchArr = bmfcCode.match(/outlineThickness=(\d+)/);
            if (matchArr && matchArr[1] != "0") {
                bmfcCode = bmfcCode.replace(/alphaChnl=\d+/, "alphaChnl=1");
                bmfcCode = bmfcCode.replace(/redChnl=\d+/, "redChnl=0");
                bmfcCode = bmfcCode.replace(/greenChnl=\d+/, "greenChnl=0");
                bmfcCode = bmfcCode.replace(/blueChnl=\d+/, "blueChnl=0");
            } else {
                //不然字会有黑色脏边
                bmfcCode = bmfcCode.replace(/alphaChnl=\d+/, "alphaChnl=0");
                bmfcCode = bmfcCode.replace(/redChnl=\d+/, "redChnl=4");
                bmfcCode = bmfcCode.replace(/greenChnl=\d+/, "greenChnl=4");
                bmfcCode = bmfcCode.replace(/blueChnl=\d+/, "blueChnl=4");
            }
            files.checkAndWrite(bmfcPath, bmfcCode);

            const textPath = conf.src + "text.txt";
            const othersTxtPath = conf.src + "others.txt";
            files.isFile(othersTxtPath) && conf.sb.push(files.readStr(othersTxtPath));
            const csBytes = this.countCs(conf.sb.join(""), conf.cs);
            csBytes ? files.writeBytes(textPath, csBytes) : files.writeStr(textPath, "");
            files.writeStr(conf.src + "cs.txt", conf.cs.join("\n"));
            const png0Path = conf.src + conf.name + ".png";
            const glyphsDirPath = conf.src + "glyphs/";
            if (files.isFile(png0Path)) {
                const glyphsPath = conf.src + "glyphs.txt";
                if (files.isFile(glyphsPath)) {
                    files.clearOrMakeDir(glyphsDirPath);
                    const sharp = await Sharps.fromFile(png0Path);
                    if (sharp.failReason) {
                        console.error(sharp.failReason);
                    } else {
                        const rgbas = await Sharps.getRGBAs(sharp.img);
                        const hasPixels: Array<boolean> = [];
                        const w = sharp.wid;
                        const h = sharp.hei;
                        for (let x: number = 0; x < w; x++) {
                            for (let y: number = 0; y < h; y++) {
                                const i = (y * w + x) << 2;
                                if (rgbas[i + 3]) {
                                    hasPixels[x] = true;
                                    break;
                                }
                            }
                        }
                        conf.空白阈值 > 0 || (conf.空白阈值 = 2);
                        const xws = this.根据空白阈值分段(hasPixels, conf.空白阈值);
                        let i: number = 0;
                        for (const c of files.readStr(glyphsPath).replace(/\s+/g, "").split("")) {
                            const x0 = xws[i++]!;
                            const w0 = xws[i++]!;
                            if (x0 > -1 && w0 > 0) {
                                const cRGBAs = Sharps.getEmptyRGBAs(w0, h);
                                Sharps.copy(rgbas, w, x0, 0, cRGBAs, w0, 0, 0, w0, h);
                                const cImg = Sharps.fromRGBAs(cRGBAs, w0, h);
                                const cImgBytes = await cImg.png().toBuffer();
                                cImg.destroy();
                                files.writeBytes(glyphsDirPath + this.c2str(c) + ".png", cImgBytes);
                            } else {
                                console.error(glyphsPath + "\nc=" + c + " 无对应字型");
                            }
                        }
                    }
                    sharp.img?.destroy();
                }
            }
            if (files.isDir(glyphsDirPath)) {
                if (conf.主字体) {
                    console.error("主字体不支持 glyphs");
                } else {
                    const othersDirPath = conf.src + "others/";
                    if (files.isDir(othersDirPath)) {
                        files.copyFiles(othersDirPath, glyphsDirPath);
                    }
                    this.getGlyphPaths(glyphsDirPath);
                    conf.cs.length = 0;
                    this.sb.length = 0;
                    let sbIndex: number = 0;
                    for (const cCode in this.glyphPaths) {
                        this.sb[sbIndex++] = "\nicon=\"";
                        this.sb[sbIndex++] = this.glyphPaths[cCode]!.replace(conf.src, "");
                        this.sb[sbIndex++] = "\",";
                        this.sb[sbIndex++] = cCode;
                        this.sb[sbIndex++] = ",0,0,0";
                        conf.cs.push(String.fromCharCode(parseInt(cCode)));
                    }
                    files.writeStr(conf.src + "cs.txt", conf.cs.join("\n"));
                    if (conf.cs.length) {
                        files.writeStr(bmfcPath, bmfcCode.replace(/# imported icon images[\s\S]*$/, "# imported icon images\n" + this.sb.join("")));
                        CMD.cd(conf.src);
                        CMD.add(this.bmFontEXEPath + " -c conf.bmfc -o gen\\output.fnt");
                    } else {
                        console.error("无字型：" + glyphsDirPath);
                    }
                }
            } else {
                if (csBytes) {
                    CMD.cd(conf.src);
                    CMD.add(this.bmFontEXEPath + " -t text.txt -c conf.bmfc -o gen\\output.fnt");
                } else {
                    console.error("text.txt 为空：" + textPath);
                }
            }
        }
        Utils.hideLoading();
        const result = await CMD.run("生成位图字体中……");
        Utils.showLoading("裁剪有效区域中……");
        result.err && Utils.errMsg(result.err);
        for (const conf of this.confs) {
            files.mkdir(conf.dest);
            const fntPath = conf.gen + "output.fnt";
            const destFNTPath = conf.dest + conf.name + ".fnt";
            this.fntPaths.push(destFNTPath);
            if (files.isFile(fntPath)) {
                const fntCode = files.readStr(fntPath);
                if (fntCode.includes("chars count=0")) {
                    Utils.errMsg("生成字体出错：" + fntPath);
                } else {
                    files.checkAndWrite(destFNTPath, files.addUTF8BOM(fntCode.replace("output_0.png", conf.name + "_0.png")));
                    const charInfos: { [key: number]: CharInfo } = {};
                    for (const matchStr of fntCode.match(/id=\d+\s+x=\d+\s+y=\d+\s+width=\d+\s+height=\d+/g)!) {
                        const matchArr = matchStr.match(/\d+/g)!;
                        charInfos[parseInt(matchArr[0])] = {
                            x: parseInt(matchArr[1]!),
                            y: parseInt(matchArr[2]!),
                            w: parseInt(matchArr[3]!),
                            h: parseInt(matchArr[4]!)
                        };
                    }
                    await this.裁剪有效区域(conf, charInfos);
                }
            } else {
                Utils.errMsg("生成字体失败：" + fntPath);
            }
        }
        Utils.hideLoading();

        return undefined!;
    }
    private getOverrideStrss(code: string): void {
        if (code.includes('"CCPropertyOverrideInfo"')) {
            const prefab: Array<{ __type__: string, propertyPath: Array<string>, value: string, localID: Array<string> }> = Utils.tryParse(code);
            let i: number = -1;
            for (const element of prefab) {
                i++;
                if (element.__type__ == "CCPropertyOverrideInfo") {
                    if (element.propertyPath?.length == 1 && element.propertyPath[0] == "_string") {
                        const nextElement = prefab[i + 1];
                        if (nextElement?.__type__ == "cc.TargetInfo") {
                            if (nextElement.localID?.length == 1) {
                                const localID = nextElement.localID[0]!;
                                let strs: Array<string> = this.overrideStrss[localID]!;
                                strs || (this.overrideStrss[localID] = strs = []);
                                strs.push(element.value);
                                //console.log("localID=" + localID + ", value=" + element.value);
                            }
                        }
                    }
                }
            }
        }
    }
    private collectSceneOrPrefabs(code: string, txtRegG: RegExp, txtReg: RegExp, uuidGroupIndex: number, strGroupIndex: number, uuidsByFileId?: { [key: string]: string }, guids?: { [key: string]: string }): void {
        code = code.replace(/<[^>]+>/g, "");
        code = code.replace(/"_fontColor": \{[^}]*\}/g, "");
        const matchArrG = code.match(txtRegG);
        if (matchArrG) {
            for (const matchStr of matchArrG) {
                const matchArr = matchStr.match(txtReg)!;
                let uuid: string = matchArr[uuidGroupIndex]!;
                if (guids) {
                    guids[uuid] && (uuid = guids[uuid]!);
                }
                const conf = this.confsByUUID[uuid];
                const str = JSON.parse(matchArr[strGroupIndex]!).replace(/[\r\n]/g, "");
                if (conf && !conf.主字体) {
                    conf.sb.push(str);
                } else {
                    this.mainSb.push(str);
                }
                if (uuidsByFileId) {
                    if (matchArr[3]) {//"_id": "43Giw/ep5K4aqeODCP7T9h"
                    } else {
                        const matchArr = code.slice(code.indexOf(matchStr)).match(/"__type__": "cc.CompPrefabInfo",\s*"fileId": "([^"]+)"/)!;
                        uuidsByFileId[matchArr[1]!] = uuid;
                    }
                }
            }
        }
    }
    private collectCs(filePath: string): void {
        if (this.conf0.扫描主字体.排除) {
            for (const excludeDirOrFilePath of this.conf0.扫描主字体.排除) {
                if (filePath.startsWith(excludeDirOrFilePath)) return;
            }
        }
        let code: string = files.readStr(filePath);
        switch (filePath.match(/\.\w+$/)![0]) {
            case ".fire":
                switch (this.type) {
                    case "cc24":
                        // case "cc38":
                        // case "tj1":
                        this.collectSceneOrPrefabs(code, this.txtRegCC24G, this.txtRegCC24, 2, 1);
                        break;
                    default:
                        console.error(this.type + " 不支持 fire：" + filePath);
                        break;
                }
                break;
            case ".scene":
                switch (this.type) {
                    // case "cc24":
                    case "cc38":
                        this.collectSceneOrPrefabs(code, this.txtRegCC38G, this.txtRegCC38, 2, 1, this.uuidsByFileId);
                        this.getOverrideStrss(code);
                        break;
                    case "tj1":
                        this.collectSceneOrPrefabs(code, this.txtRegTJ1G, this.txtRegTJ1, 1, 2, undefined, this.guids);
                        this.getOverrideStrss(code);
                        break;
                    default:
                        console.error(this.type + " 不支持 scene：" + filePath);
                        break;
                }
                break;
            case ".prefab":
                switch (this.type) {
                    case "cc24":
                        this.collectSceneOrPrefabs(code, this.txtRegCC24G, this.txtRegCC24, 2, 1);
                        break;
                    case "cc38":
                        this.collectSceneOrPrefabs(code, this.txtRegCC38G, this.txtRegCC38, 2, 1, this.uuidsByFileId);
                        this.getOverrideStrss(code);
                        break;
                    case "tj1":
                        this.collectSceneOrPrefabs(code, this.txtRegTJ1G, this.txtRegTJ1, 1, 2, undefined, this.guids);
                        break;
                }
                break;
            case ".ts":
            case ".cs":
                //去掉注释（不是很严格）
                code = code.replace(/\/\*[\s\S]+?\*\//g, "");
                code = code.replace(/\/\/.*/g, "");
                this.mainSb.push(code);
                break;
            case ".json":
                this.mainSb.push(code);
                break;
            default:
                console.error("未处理的文件：" + filePath);
                break;
        }
    }
    private countCs(str: string, cs: Array<string>): Buffer {
        Utils.clearObj(this.mark);
        for (const c of str) {
            this.mark[c] = true;
        }
        delete this.mark["\n"];
        delete this.mark["\r"];
        // delete this.mark[" "];
        delete this.mark["\t"];
        delete this.mark["\b"];
        cs.length = 0;
        for (const c in this.mark) {
            if (c.length == 1) {
                cs.push(c);
            } else {
                console.error("len=" + c.length + " != 1 ：" + c);
            }
        }
        if (cs.length) {
            cs.sort();
            return files.addUTF8BOM(cs.join(""));
        }
        return null!;
    }
    private 根据空白阈值分段(hasPixels: Array<boolean>, 空白阈值: number): Array<number> {
        const xws: Array<number> = [];
        let x: number = -1;
        let firstX: number = -1;
        while (++x < hasPixels.length) {
            if (hasPixels[x]) {
                firstX = x;
                break;
            }
        }
        if (firstX == -1) {
            //hasPixels.length == 0 或 hasPixels 全为 false
            return xws;
        }

        let lastX: number = hasPixels.length;
        while (lastX--) {
            if (hasPixels[lastX]) {
                break;
            }
        }

        let blankWid: number = 0;
        let startX: number = -1;
        let endX: number = -1;
        for (x = firstX; x <= lastX; x++) {
            if (hasPixels[x]) {
                blankWid = 0;
                if (startX == -1) startX = x;
            }
            else {
                if (blankWid == 0) endX = x;
                if (++blankWid < 空白阈值) { } else {
                    if (startX > -1) {
                        xws.push(startX, endX - startX);
                        startX = -1;
                    }
                }
            }
        }
        xws.push(startX, x - startX);
        return xws;
    }
    private c2str(c: string): string {
        if (c >= 'a' && c <= 'z') {
            return "小写" + c;
        }
        switch (c) {
            case '\\':
            case '/':
            case ':':
            case '*':
            case '?':
            case '"':
            case '<':
            case '>':
            case '|':
                return 'x' + c.charCodeAt(0).toString(16);
            default:
                return c;
        }
    }
    private getGlyphPaths(dirPath: string): void {
        Utils.clearObj(this.glyphPaths);
        for (const glyphPath of files.getFilePaths(dirPath, true, ".png")) {
            const name = glyphPath.match(/([^\/]+)\.png$/)![1]!;
            let matchArr: Array<string> = name.match(/^x([\da-fA-F]{2})$/)!;
            let cCode: number;
            if (matchArr) {
                cCode = parseInt(matchArr[1]!, 16);
            } else {
                matchArr = name.match(/^(?:大写|小写)(.)$/)!;
                if (matchArr) {
                    cCode = matchArr[1]!.charCodeAt(0);
                } else if (name.length == 1) {
                    cCode = name.charCodeAt(0);
                } else {
                    console.error("奇怪的字型：" + glyphPath);
                    continue;
                }
            }
            this.glyphPaths[cCode] = glyphPath;
        }
        // console.log(Utils.tryStringify(glyphPaths, undefined, "\t"));
    }
    private async 裁剪有效区域(conf: Conf, charInfos: { [key: number]: CharInfo }) {
        const sharp = await Sharps.fromFile(conf.gen + "output_0.png");
        if (sharp.failReason) {
            console.error(sharp.failReason);
        } else {
            let maxWid: number = 0;
            let maxHei: number = 0;
            for (const cCode in charInfos) {
                const charInfo = charInfos[cCode]!;
                const right = charInfo.x + charInfo.w;
                right > maxWid && (maxWid = right);
                const bottom = charInfo.y + charInfo.h;
                bottom > maxHei && (maxHei = bottom);
            }
            maxWid = maxWid + 3 >> 2 << 2;
            maxHei = maxHei + 3 >> 2 << 2;

            let clip: sharp.Sharp = sharp.img.extract({ left: 0, top: 0, width: maxWid, height: maxHei });
            if (files.isDir(conf.src + "replace/")) {
                const rgbas = await Sharps.getRGBAs(clip);
                clip.destroy();
                this.getGlyphPaths(conf.src + "replace/");
                // console.log("外科手术式替换指定字符：" + Utils.tryStringify(glyphPaths, undefined, "\t"));
                for (const _cCode in this.glyphPaths) {
                    const cCode = parseInt(_cCode);
                    const charInfo = charInfos[cCode];
                    if (charInfo) {
                        Sharps.fillRect(rgbas, maxWid, charInfo.x, charInfo.y, charInfo.w, charInfo.h);
                        const sharp = await Sharps.fromFile(this.glyphPaths[cCode]!);
                        if (sharp.failReason) {
                            console.error(sharp.failReason);
                        } else {
                            const srcRGBAs = await Sharps.getRGBAs(sharp.img);
                            const w = sharp.wid;
                            const h = sharp.hei;
                            Sharps.copy(srcRGBAs, w, 0, 0, rgbas, maxWid, charInfo.x + (charInfo.w - w >> 1), charInfo.y + (charInfo.h - h >> 1), w, h);
                        }
                        sharp.img?.destroy();
                    } else {
                        console.error("无字符：" + String.fromCharCode(cCode) + " " + cCode);
                    }
                }
                clip = Sharps.fromRGBAs(rgbas, maxWid, maxHei);
            }
            const pngBytes = await clip.png().toBuffer();
            clip.destroy();
            files.checkAndWrite(conf.dest + conf.name + "_0.png", pngBytes);
        }
        sharp.img?.destroy();
    }
}