import ReadWriteStr from "../utils/ReadWriteStr";
import Store, { PageInfo } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: PageInfo;
    private dir!: HTMLInputElement;
    private ends!: HTMLInputElement;
    private dests: string[] = [];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/各种编码");

        this.text("目录：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";
        this.br();

        this.text("结尾：");
        const ends = this.input("text");
        ends.id = "ends";
        ends.style.width = "200px";

        const btn = this.input("button");
        btn.value = "转换";
        btn.onclick = () => {
            outputErr("");
            this.dests.length = 0;
            const ends = this.ends.value.replace(/^\s*|\s*$/g, "").split(/[,\s]+/);
            let i: number = ends.length;
            while (i--) {
                ends[i] || ends.splice(i, 1);
            }
            if (ends.length) {
                this.info.dir = this.dir.value;
                if (files.isDir(this.info.dir)) {
                    this.info.dir = files.normalizeDirPath(this.info.dir);
                    this.info.str = ends.join(",");
                    Store.flush();
                    for (const filePath of files.getFilePaths(this.info.dir, true, ...ends)) {
                        ReadWriteStr.read(filePath);
                        if (ReadWriteStr.write()) {
                            this.dests.push(filePath);
                        }
                    }
                } else {
                    outputErr("无 " + this.info.dir);
                }
            } else {
                outputErr("无 ends");
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.dests.length) {
            const span = this.span(this.dests.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            let i: number = -1;
            for (const dest of this.dests) {
                i++;
                this.text(files.openLink(dest, 2));
                this.br();
            }
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
            this.ends.value = this.info.str;
        };
    }
}
