import Store, { PathDir } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import 生成图标 from "../utils/生成图标";
import Page from "./Page";

export default class extends Page {
    protected info!: PathDir;
    private path!: HTMLInputElement;
    private dir!: HTMLInputElement;
    private srcs!: string[];
    private results!: string[];
    protected _refresh(): void {
        this.info.path || (this.info.path = Utils.appDirPath + "tests/生成图标/原图.jpg");
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/生成图标/覆盖");

        this.text("原图标：");
        const path = this.input("text");
        path.id = "path";
        path.style.width = "400px";
        this.br();

        this.text("覆盖目录：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";
        this.br();

        const btn = this.input("button");
        btn.value = "生成";
        btn.onclick = async () => {
            outputErr("");
            this.info.path = files.normalizeFilePath(this.path.value);
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isFile(this.info.path)) {
                if (files.isDir(this.info.dir)) {
                    if (this.srcs) {
                        this.srcs.length = 0;
                        this.results.length = 0;
                    } else {
                        this.srcs = [];
                        this.results = [];
                    }
                    const failReason = await 生成图标.读取原图标(this.info.path);
                    if (failReason) {
                        outputErr(failReason);
                    } else {
                        let i: number = -1;
                        for (const filePath of files.getFilePaths(this.info.dir, true, ".jpg", ".jpeg", ".png")) {
                            i++;
                            this.srcs[i] = filePath;
                            this.results[i] = await 生成图标.doo(filePath);
                        }
                    }
                    生成图标.done();
                } else {
                    outputErr("无覆盖目录：" + this.info.dir);
                }
            } else {
                outputErr("无原图标：" + this.info.path);
            }
            this.refresh();
        };

        if (files.isFile(this.info.path) && files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                const result = this.results[i];
                const span = tr.td().span();
                if (result) {
                    span.style.color = "red";
                    span.text(result);
                } else {
                    span.style.color = "green";
                    span.text('覆盖成功！');
                }
            }
        }
        this.onRefresh = () => {
            this.path.value = this.info.path;
            this.dir.value = this.info.dir;
        };
    }
}
