import Store, { PathDir } from "../utils/Store";
import Page from "./Page";
import Utils from "../utils/Utils";
import CMD from "../utils/CMD";
import files from "../utils/files";

export default class extends Page {
    protected info!: PathDir;
    private dir!: HTMLInputElement;
    private diskSN!: string;
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests");

        this.text("盘符或路径：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";

        const btn = this.input("button");
        btn.value = "获取";
        btn.onclick = async () => {
            outputErr("");
            this.diskSN = undefined!;
            this.info.dir = files.normalizeFilePath(this.dir.value);
            Store.flush();
            if (this.info.dir) { } else {
                outputErr("请填写盘符！");
                return;
            }
            let disk: string;
            if (this.info.dir.length == 1) {
                disk = this.info.dir + ":";
            } else {
                const matchArr = this.info.dir.match(/\w\:/);
                if (matchArr) {
                    disk = matchArr[0];
                } else {
                    outputErr("匹配盘符失败：" + this.info.dir);
                    return;
                }
            }
            const diskSNPath = Utils.appDirPath + "temps/" + (1000000000 + Math.random() * 1000000000 >>> 0) + ".txt";
            const _diskSNPath = CMD.normalizePath(diskSNPath, true);
            CMD.standBy();
            CMD.add(`@echo off
del ${_diskSNPath} /f /q
setlocal enabledelayedexpansion
for /f "tokens=2 delims==" %%i in ('wmic logicaldisk where Name^="${disk}" assoc:value /RESULTCLASS:Win32_DiskPartition ^|findstr /i "DiskIndex="') do set diskIndex=%%i
echo diskIndex=%diskIndex%
set result=
for /f "skip=1" %%i in ('wmic diskdrive %diskIndex% get SerialNumber') do  set result=!result!%%i
set _date=%date%
set _time=%time%
echo %result% %_date:~0,4%-%_date:~5,2%-%_date:~8,2% %_time:~0,2%:%_time:~3,2%:%_time:~6,2% > ${_diskSNPath}`);
            await CMD.run("获取物理盘序列号中……");
            if (files.isFile(diskSNPath)) { } else {
                outputErr("无 " + diskSNPath);
                return;
            }
            this.diskSN = files.readStr(diskSNPath).replace(/^\s*|\s*$/g, "");
            const matchArr = this.diskSN.match(/^(.+?) (\d\d\d\d)-(\d\d)-(\d\d) (\d\d):(\d\d):(\d\d)$/);
            if (matchArr) { } else {
                outputErr(diskSNPath + "\n匹配失败：" + Utils.tryStringify(this.diskSN));
                return;
            }
            const date = new Date();
            const snDate = new Date(parseInt(matchArr[2]!), parseInt(matchArr[3]!) - 1, parseInt(matchArr[4]!), parseInt(matchArr[5]!), parseInt(matchArr[6]!), parseInt(matchArr[7]!));
            const d = date.getTime() - snDate.getTime();
            if (d < 60 * 1000) { } else {
                outputErr("d=" + d + " " + Utils.tryStringify(this.diskSN) + "\n" + date + " " + snDate);
                return;
            }
            this.diskSN = matchArr[1]!;
            this.refresh();
        };

        if (this.diskSN) {
            this.br();
            this.text("序列号：");
            this.span().点击复制单元格内容(this.diskSN);
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
        };
    }
}
