import { PageInfo } from "../utils/Store";
import files from "../utils/files";
import Page from "./Page";
import Utils from "../utils/Utils";

export default class extends Page {
    protected info!: PageInfo;
    private scriptPath!: string;
    private code!: HTMLInputElement;
    private result!: HTMLInputElement;
    protected _refresh(): void {
        this.scriptPath = Utils.appDirPath + "tests/机器人/code.js";

        const code = this.textarea();
        code.id = "code";
        code.rows = 12;
        code.style.width = "600px";
        code.onchange = () => {
            files.writeStr(this.scriptPath, this.code.value);
        };
        this.br();

        const btn = this.input("button");
        btn.value = "运行";
        btn.onclick = async () => {
            outputErr("");
            this.result.value = await eval('(async function(){' + files.readStr(this.scriptPath) + '})()');
        };
        this.text("运行结果：");
        this.br();

        const result = this.textarea();
        result.id = "result";
        result.rows = 4;
        result.style.width = "600px";
        this.onRefresh = () => {
            this.code.value = files.readStr(this.scriptPath);
        };
    }
}
