import Store, { 拼音Args } from "../utils/Store";
import Utils from "../utils/Utils";
import Page from "./Page";

export default class extends Page {
    protected info!: 拼音Args;
    private txt1!: HTMLInputElement;
    private style!: HTMLInputElement;
    private options: IPinyinOptions = {};
    private txt2!: HTMLInputElement;
    protected _refresh(): void {
        const txt1 = this.textarea();
        txt1.id = "txt1";
        txt1.rows = 4;
        txt1.style.width = "400px";
        txt1.oninput = this.转换;
        this.br();

        const style = this.select("带声调", "不带声调", "首字母");
        style.id = "style";
        style.style.width = "80px";
        style.onchange = () => {
            outputErr("");
            this.info.style = this.style.value as "带声调";
            Store.flush();
            this.转换();
        };
        this.span(" >>> ").style.color = "green";
        this.br();

        const txt2 = this.textarea();
        txt2.id = "txt2";
        txt2.rows = 8;
        txt2.style.width = "400px";

        this.onRefresh = () => {
            this.txt1.value = this.info.str;
            this.转换();
        };
    }
    private 转换 = () => {
        outputErr("");
        switch (this.info.style) {
            case "不带声调":
                this.options.style = pinyin.STYLE_NORMAL;
                break;
            case "首字母":
                this.options.style = pinyin.STYLE_FIRST_LETTER;
                break;
            default:
                this.info.style = "带声调";
                delete this.options.style;
                break;
        }
        this.txt2.value = Utils.tryStringify(pinyin(this.info.str = this.txt1.value, this.options));
        Store.flush();
    }
}
