import Store, { RenameArgs } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import 批量重命名 from "../utils/批量重命名";
import Page from "./Page";

export default class extends Page {
    protected info!: RenameArgs;
    private dir!: HTMLInputElement;
    private mode!: HTMLInputElement;
    private prefix!: HTMLInputElement;
    private 编号位数!: HTMLInputElement;
    private reg!: HTMLInputElement;
    private replace!: HTMLInputElement;
    private srcs!: string[];
    private dests: string[] = [];

    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/图片们");

        this.text("目录：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";
        dir.oninput = () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            this.refresh();
        };
        this.br();

        this.text("模式：");
        const mode = this.select("编号", "正则");
        mode.id = "mode";
        mode.style.width = "70px";
        mode.onchange = () => {
            outputErr("");
            this.info.mode = this.mode.value as "编号";
            Store.flush();
            this.refresh();
        };

        this.text("编号位数：");
        const 编号位数 = this.input("text");
        编号位数.id = "编号位数";
        编号位数.style.width = "20px";
        编号位数.oninput = this.change;

        switch (this.info.mode) {
            case "正则":
                this.br();
                this.text("正则：");
                const reg = this.input("text");
                reg.id = "reg";
                reg.style.width = "160px";
                reg.oninput = () => {
                    outputErr("");
                    this.info.reg = this.reg.value;
                    批量重命名.setReg(this.info);
                    Store.flush();
                    this.preview();
                };

                this.text("替换为：");
                const replace = this.input("text");
                replace.id = "replace";
                replace.style.width = "160px";
                replace.oninput = this.change;
                批量重命名.setReg(this.info);
                break;
            default:
                this.info.mode = "编号";
                this.text("前缀：");
                const prefix = this.input("text");
                prefix.id = "prefix";
                prefix.style.width = "160px";
                prefix.oninput = this.change;
                break;
        }
        this.br();

        switch (this.info.type) {
            case "目录":
                break;
            default:
                this.info.type = "文件";
                break;
        }

        this.radios("type", this.info.type, "文件", "目录").onchange = () => {
            this.info.type = (document.querySelector('input[name="type"]:checked') as HTMLInputElement).value as "文件";
            Store.flush();
            this.refresh();
        };

        const btn = this.input("button");
        btn.value = "重命名";
        btn.onclick = () => {
            outputErr("");
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                switch (this.info.type) {
                    case "目录":
                        files.cutDir(src, this.dests[i]!);
                        break;
                    default:
                        files.cutFile(src, this.dests[i]!);
                        break;
                }
            }
            this.preview();
        };

        if (files.isDir(this.info.dir)) {
            switch (this.info.type) {
                case "目录":
                    this.srcs = files.getDirPaths(this.info.dir, true);
                    let i: number = this.srcs.length;
                    while (i--) {
                        this.srcs[i] = this.srcs[i]!.substring(0, this.srcs[i]!.length - 1);
                    }
                    break;
                default:
                    this.srcs = files.getFilePaths(this.info.dir, true);
                    break;
            }
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个" + this.info.type);

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                tr.td().id = "td" + i;
            }
        } else {
            outputErr("无 " + this.info.dir);
            this.srcs = undefined!;
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
            this.mode.value = this.info.mode;
            this.编号位数.value = this.info.编号位数 + "";
            switch (this.info.mode) {
                case "正则":
                    this.reg.value = this.info.reg;
                    this.replace.value = this.info.replace;
                    break;
                default:
                    this.prefix.value = this.info.prefix;
                    break;
            }
            if (this.srcs) {
                this.preview();
            }
        };
    }
    private change = () => {
        outputErr("");
        switch (this.info.mode) {
            case "正则":
                this.info.replace = this.replace.value;
                break;
            default:
                this.info.prefix = this.prefix.value;
                break;
        }
        this.info.编号位数 = parseInt(this.编号位数.value);
        this.info.编号位数 > 0 || (this.info.编号位数 = 0);
        Store.flush();
        this.preview();
    }
    private preview(): void {
        let i: number = -1;
        for (const src of this.srcs) {
            i++;
            const dest = 批量重命名.rename(this.info, i, src);
            this.dests[i] = dest;
            ((this as any)["td" + i] as HTMLElement).innerHTML = files.openLink(dest, 2);
        }
    }
}
