import Converts from "../utils/Converts";
import ReadWriteStr from "../utils/ReadWriteStr";
import Sharps from "../utils/Sharps";
import Store, { Fixs } from "../utils/Store";
import UUIDs from "../utils/UUIDs";
import Utils from "../utils/Utils";
import files from "../utils/files";
import 项目类型, { PojType } from "../utils/项目类型";
import Page, { Element } from "./Page";

type Reason = "文件名去掉空白逗号分号" | "文件名后缀改小写" | "文件名jpeg改jpg" | "PNG去掉周围空白" | "PNG再存" | "文本存成UTF8" | "纹理packable" | "纹理premultiplyAlpha" | "纹理trimType" | "自动图集宽" | "自动图集高" | "自动图集间距" | "自动图集旋转" | "自动图集正方形" | "自动图集二次幂" | "自动图集扩边" | "预制体名字" | "预制体premultiplyAlpha" | "跨bundle引用";
interface 待修正 {
    reason: Reason;
    info: string;
    fix?: () => Promise<void>;
}
export default class extends Page {
    protected info!: Fixs;
    private poj!: HTMLInputElement;
    private pojType!: PojType;

    private premultiplyAlphaRegG: RegExp = /("_?(?:premultiplyAlpha|premultipliedAlpha)"): (true|false)/g;
    private premultiplyAlphaReg: RegExp = new RegExp(this.premultiplyAlphaRegG.source);

    private 处理文件名!: HTMLInputElement;
    private 处理文件名td!: HTMLElement;
    private 文件名去掉空白逗号分号!: HTMLInputElement;
    private 文件名后缀改小写!: HTMLInputElement;
    private 文件名jpeg改jpg!: HTMLInputElement;

    private 处理PNG!: HTMLInputElement;
    private 处理PNGtd!: HTMLElement;
    private PNG去掉周围空白!: HTMLInputElement;
    private PNG再存!: HTMLInputElement;

    private 处理文本!: HTMLInputElement;
    private 处理文本td!: HTMLElement;
    private 文本存成UTF8!: HTMLInputElement;

    private 处理纹理!: HTMLInputElement;
    private 处理纹理td!: HTMLElement;
    private 纹理packable!: HTMLInputElement;
    private 纹理premultiplyAlpha!: HTMLInputElement;
    private 纹理trimType!: HTMLInputElement;

    private 处理自动图集!: HTMLInputElement;
    private 处理自动图集td!: HTMLElement;
    private 自动图集宽!: HTMLInputElement;
    private 自动图集高!: HTMLInputElement;
    private 自动图集间距!: HTMLInputElement;
    private 自动图集旋转!: HTMLInputElement;
    private 自动图集正方形!: HTMLInputElement;
    private 自动图集二次幂!: HTMLInputElement;
    private 自动图集扩边!: HTMLInputElement;

    private 处理预制体!: HTMLInputElement;
    private 处理预制体td!: HTMLElement;
    private 预制体名字!: HTMLInputElement;
    private 预制体premultiplyAlpha!: HTMLInputElement;

    private 跨bundle引用!: HTMLInputElement;
    private filePathsByUUID: { [key: string]: string } = {};
    private bundleDirPathss: { [key: string]: Array<string> } = {};
    private bundleNames: { [key: string]: string } = {};

    private assetsDirPath!: string;
    private dirOrFilePaths!: string[];
    private 待修正ss!: { [key: number]: 待修正[] };
    protected _refresh(): void {
        this.info.poj || (this.info.poj = Utils.appDirPath + "tests/BMFont/cc24");

        this.text("项目：");
        const poj = this.input("text");
        poj.id = "poj";
        poj.style.width = "400px";
        poj.onchange = () => {
            outputErr("");
            this.info.poj = this.poj.value;
            Store.flush();
            this.refresh();
        };
        if (this.info.poj) {
            this.info.poj = files.normalizeDirPath(this.info.poj);
            if (files.isDir(this.info.poj)) {
                this.pojType = 项目类型.getType(this.info.poj);
            } else {
                this.pojType = undefined!;
            }
        } else {
            this.info.poj = "";
            this.pojType = undefined!;
        }
        this.pojType && this.text("项目类型：" + this.pojType);
        this.br();

        const table = this.table();
        let tr = table.tr();
        const 处理文件名 = tr.td().checkbox("处理文件名");
        处理文件名.id = "处理文件名";
        处理文件名.onchange = () => {
            (this.info.处理文件名.启用 = this.处理文件名.checked) ? this.启用容器(this.处理文件名td) : this.禁用容器(this.处理文件名td);
            Store.flush();
        };
        const 处理文件名td = tr.td();
        处理文件名td.id = "处理文件名td";
        const 文件名去掉空白逗号分号 = 处理文件名td.checkbox("去掉空白逗号分号");
        文件名去掉空白逗号分号.id = "文件名去掉空白逗号分号";
        文件名去掉空白逗号分号.onchange = () => {
            this.info.处理文件名.去掉空白逗号分号 = this.文件名去掉空白逗号分号.checked;
            Store.flush();
        };
        const 文件名后缀改小写 = 处理文件名td.checkbox("后缀改小写");
        文件名后缀改小写.id = "文件名后缀改小写";
        文件名后缀改小写.onchange = () => {
            this.info.处理文件名.后缀改小写 = this.文件名后缀改小写.checked;
            Store.flush();
        };
        const 文件名jpeg改jpg = 处理文件名td.checkbox("jpeg改jpg");
        文件名jpeg改jpg.id = "文件名jpeg改jpg";
        文件名jpeg改jpg.onchange = () => {
            this.info.处理文件名.jpeg改jpg = this.文件名jpeg改jpg.checked;
            Store.flush();
        };

        tr = table.tr();
        const 处理PNG = tr.td().checkbox("处理PNG");
        处理PNG.id = "处理PNG";
        处理PNG.onchange = () => {
            (this.info.处理PNG.启用 = this.处理PNG.checked) ? this.启用容器(this.处理PNGtd) : this.禁用容器(this.处理PNGtd);
            Store.flush();
        };
        const 处理PNGtd = tr.td();
        处理PNGtd.id = "处理PNGtd";
        const PNG去掉周围空白 = 处理PNGtd.checkbox("去掉周围空白");
        PNG去掉周围空白.id = "PNG去掉周围空白";
        PNG去掉周围空白.onchange = () => {
            this.info.处理PNG.去掉周围空白 = this.PNG去掉周围空白.checked;
            Store.flush();
        };
        const PNG再存 = 处理PNGtd.checkbox("再存");
        PNG再存.id = "PNG再存";
        PNG再存.onchange = () => {
            this.info.处理PNG.再存 = this.PNG再存.checked;
            Store.flush();
        };

        tr = table.tr();
        const 处理文本 = tr.td().checkbox("处理文本");
        处理文本.id = "处理文本";
        处理文本.onchange = () => {
            (this.info.处理文本.启用 = this.处理文本.checked) ? this.启用容器(this.处理文本td) : this.禁用容器(this.处理文本td);
            Store.flush();
        };
        const 处理文本td = tr.td();
        处理文本td.id = "处理文本td";
        const 文本存成UTF8 = 处理文本td.checkbox("存成UTF8");
        文本存成UTF8.id = "文本存成UTF8";
        文本存成UTF8.onchange = () => {
            this.info.处理文本.存成UTF8 = this.文本存成UTF8.checked;
            Store.flush();
        };

        tr = table.tr();
        const 处理纹理 = tr.td().checkbox("处理纹理 ");
        处理纹理.id = "处理纹理";
        处理纹理.onchange = () => {
            (this.info.处理纹理.启用 = this.处理纹理.checked) ? this.启用容器(this.处理纹理td) : this.禁用容器(this.处理纹理td);
            Store.flush();
        };
        const 处理纹理td = tr.td();
        处理纹理td.id = "处理纹理td";
        处理纹理td.text(" packable");
        const 纹理packable = 处理纹理td.select("不处理", "true", "false");
        纹理packable.id = "纹理packable";
        纹理packable.style.width = "64px";
        纹理packable.onchange = () => {
            this.info.处理纹理.packable = this.纹理packable.value as "不处理";
            Store.flush();
        };
        处理纹理td.text(" premultiplyAlpha");
        const 纹理premultiplyAlpha = 处理纹理td.select("不处理", "true", "false");
        纹理premultiplyAlpha.id = "纹理premultiplyAlpha";
        纹理premultiplyAlpha.style.width = "64px";
        纹理premultiplyAlpha.onchange = () => {
            this.info.处理纹理.premultiplyAlpha = this.纹理premultiplyAlpha.value as "不处理";
            Store.flush();
        };
        处理纹理td.text(" trimType");
        const 纹理trimType = 处理纹理td.select("不处理", "auto", "custom", "none");
        纹理trimType.id = "纹理trimType";
        纹理trimType.style.width = "64px";
        纹理trimType.onchange = () => {
            this.info.处理纹理.trimType = this.纹理trimType.value as "不处理";
            Store.flush();
        };

        tr = table.tr();
        const 处理自动图集 = tr.td().checkbox("处理自动图集 ");
        处理自动图集.id = "处理自动图集";
        处理自动图集.onchange = () => {
            (this.info.处理自动图集.启用 = this.处理自动图集.checked) ? this.启用容器(this.处理自动图集td) : this.禁用容器(this.处理自动图集td);
            Store.flush();
        };
        const 处理自动图集td = tr.td();
        处理自动图集td.id = "处理自动图集td";
        处理自动图集td.text(" 宽");
        const 自动图集宽 = 处理自动图集td.input("text");
        自动图集宽.id = "自动图集宽";
        自动图集宽.style.width = "64px";
        自动图集宽.onchange = () => {
            this.info.处理自动图集.宽 = parseInt(this.自动图集宽.value);
            if (this.info.处理自动图集.宽 > -1) {
                this.自动图集宽.value = this.info.处理自动图集.宽 + "";
            } else {
                this.info.处理自动图集.宽 = -1;
                this.自动图集宽.value = "不处理";
            }
            Store.flush();
        };
        处理自动图集td.text(" 高");
        const 自动图集高 = 处理自动图集td.input("text");
        自动图集高.id = "自动图集高";
        自动图集高.style.width = "64px";
        自动图集高.onchange = () => {
            this.info.处理自动图集.高 = parseInt(this.自动图集高.value);
            if (this.info.处理自动图集.高 > -1) {
                this.自动图集高.value = this.info.处理自动图集.高 + "";
            } else {
                this.info.处理自动图集.高 = -1;
                this.自动图集高.value = "不处理";
            }
            Store.flush();
        };
        处理自动图集td.text(" 间距");
        const 自动图集间距 = 处理自动图集td.input("text");
        自动图集间距.id = "自动图集间距";
        自动图集间距.style.width = "64px";
        自动图集间距.onchange = () => {
            this.info.处理自动图集.间距 = parseInt(this.自动图集间距.value);
            if (this.info.处理自动图集.间距 > -1) {
                this.自动图集间距.value = this.info.处理自动图集.间距 + "";
            } else {
                this.info.处理自动图集.间距 = -1;
                this.自动图集间距.value = "不处理";
            }
            Store.flush();
        };
        处理自动图集td.text(" 旋转");
        const 自动图集旋转 = 处理自动图集td.select("不处理", "true", "false");
        自动图集旋转.id = "自动图集旋转";
        自动图集旋转.style.width = "64px";
        自动图集旋转.onchange = () => {
            this.info.处理自动图集.旋转 = this.自动图集旋转.value as "不处理";
            Store.flush();
        };
        处理自动图集td.br();
        处理自动图集td.text(" 正方形");
        const 自动图集正方形 = 处理自动图集td.select("不处理", "true", "false");
        自动图集正方形.id = "自动图集正方形";
        自动图集正方形.style.width = "64px";
        自动图集正方形.onchange = () => {
            this.info.处理自动图集.正方形 = this.自动图集正方形.value as "不处理";
            Store.flush();
        };
        处理自动图集td.text(" 二次幂");
        const 自动图集二次幂 = 处理自动图集td.select("不处理", "true", "false");
        自动图集二次幂.id = "自动图集二次幂";
        自动图集二次幂.style.width = "64px";
        自动图集二次幂.onchange = () => {
            this.info.处理自动图集.二次幂 = this.自动图集二次幂.value as "不处理";
            Store.flush();
        };
        处理自动图集td.text(" 扩边");
        const 自动图集扩边 = 处理自动图集td.select("不处理", "true", "false");
        自动图集扩边.id = "自动图集扩边";
        自动图集扩边.style.width = "64px";
        自动图集扩边.onchange = () => {
            this.info.处理自动图集.扩边 = this.自动图集扩边.value as "不处理";
            Store.flush();
        };

        tr = table.tr();
        const 处理预制体 = tr.td().checkbox("处理预制体 ");
        处理预制体.id = "处理预制体";
        处理预制体.onchange = () => {
            (this.info.处理预制体.启用 = this.处理预制体.checked) ? this.启用容器(this.处理预制体td) : this.禁用容器(this.处理预制体td);
            Store.flush();
        };
        const 处理预制体td = tr.td();
        处理预制体td.id = "处理预制体td";
        const 预制体名字 = 处理预制体td.checkbox("预制体名字");
        预制体名字.id = "预制体名字";
        预制体名字.onchange = () => {
            this.info.处理预制体.名字 = this.预制体名字.checked;
            Store.flush();
        };
        处理预制体td.text(" premultiplyAlpha");
        const 预制体premultiplyAlpha = 处理预制体td.select("不处理", "true", "false");
        预制体premultiplyAlpha.id = "预制体premultiplyAlpha";
        预制体premultiplyAlpha.style.width = "64px";
        预制体premultiplyAlpha.onchange = () => {
            this.info.处理预制体.premultiplyAlpha = this.预制体premultiplyAlpha.value as "不处理";
            Store.flush();
        };

        tr = table.tr();
        const 跨bundle引用 = tr.td().checkbox("跨bundle引用");
        跨bundle引用.id = "跨bundle引用";
        跨bundle引用.onchange = () => {
            this.info.跨bundle引用 = this.跨bundle引用.checked;
            Store.flush();
        };
        tr.td();

        const btn = this.input("button");
        btn.value = "扫描";
        btn.onclick = async () => {
            outputErr("");
            if (files.isDir(this.info.poj)) {
                if (this.pojType) {
                    this.assetsDirPath = this.info.poj + "assets/";
                    this.dirOrFilePaths = files.getDirOrFilePaths(this.assetsDirPath, true);
                    this.待修正ss ? Utils.clearObj(this.待修正ss) : this.待修正ss = {};
                    Utils.showLoading("扫描中……");

                    let i: number = -1;
                    for (const dirOrFilePath of this.dirOrFilePaths) {
                        i++;
                        const isFile = files.isFile(dirOrFilePath);
                        const name = dirOrFilePath.match(/\/([^\/]+)\/?$/)![1]!;
                        if (this.info.处理文件名.启用) {
                            if (this.info.处理文件名.去掉空白逗号分号) {
                                /[\s,;]/.test(name) && this.add(i, "文件名去掉空白逗号分号");
                            }
                            if (isFile) {
                                const ext = name.match(/(?:\.\w+)?(?:\.meta)?$/i)?.[0];
                                if (ext) {
                                    const extLower = ext.toLowerCase();
                                    if (this.info.处理文件名.后缀改小写) {
                                        ext == extLower || this.add(i, "文件名后缀改小写");
                                    }
                                    if (this.info.处理文件名.后缀改小写) {
                                        (extLower == ".jpeg" || extLower == ".jpeg.meta") && this.add(i, "文件名jpeg改jpg");
                                    }
                                }
                            }
                        }
                        if (isFile) {
                            if (this.info.处理PNG.启用) {
                                if (/\.png$/i.test(name)) {
                                    const sharp = await Sharps.fromFile(dirOrFilePath);
                                    if (sharp.failReason) {
                                        console.error(sharp.failReason);
                                    } else {
                                        if (this.info.处理PNG.去掉周围空白) {
                                            const ltrb = Sharps.获取有效区域(await Sharps.getRGBAs(sharp.img), sharp.wid, sharp.hei);
                                            if (ltrb) {
                                                ltrb.full || this.add(i, "PNG去掉周围空白");
                                            }
                                        }
                                        if (this.info.处理PNG.再存) {
                                            let result: string = Converts.optimizedPNG.get(dirOrFilePath);
                                            if (result) { } else {
                                                const pngBytes = await sharp.img.png().toBuffer();
                                                result = Converts.optimizedPNG.mark(pngBytes.length < files.stat(dirOrFilePath).size ? pngBytes : "original", dirOrFilePath);
                                            }
                                            result == "original" || this.add(i, "PNG再存", Utils.百分数(files.stat(result).size / files.stat(dirOrFilePath).size));
                                        }
                                    }
                                    sharp.img?.destroy();
                                }
                            }
                            if (this.info.处理文本.启用) {
                                if (/\.(?:ts|js|json|cs|java|txt|meta|fire|scene|prefab)$/i.test(name)) {
                                    ReadWriteStr.read(dirOrFilePath);
                                    ReadWriteStr.encoding == "utf8" || this.add(i, "文本存成UTF8");
                                }
                            }
                            if (this.info.处理纹理.启用) {
                                if (/\.(?:jpeg|jpg|png|pac)\.meta$/i.test(name)) {
                                    const code = files.readStr(dirOrFilePath);
                                    switch (this.info.处理纹理.packable) {
                                        case "true":
                                        case "false":
                                            const matchArr = code.match(/"packable": (true|false)/);
                                            if (matchArr) {
                                                matchArr[1] == this.info.处理纹理.packable || this.add(i, "纹理packable", this.info.处理纹理.packable);
                                            }
                                            break;
                                    }
                                    switch (this.info.处理纹理.premultiplyAlpha) {
                                        case "true":
                                        case "false":
                                            const matchArr = code.match(this.premultiplyAlphaReg);
                                            if (matchArr) {
                                                matchArr[2] == this.info.处理纹理.premultiplyAlpha || this.add(i, "纹理premultiplyAlpha", this.info.处理纹理.premultiplyAlpha);
                                            }
                                            break;
                                    }
                                    switch (this.info.处理纹理.trimType) {
                                        case "auto":
                                        case "custom":
                                        case "none":
                                            const matchArr = code.match(/"trimType": "(auto|custom|none)"/);
                                            if (matchArr) {
                                                matchArr[1] == this.info.处理纹理.trimType || this.add(i, "纹理trimType", this.info.处理纹理.trimType);
                                            }
                                            break;
                                    }
                                }
                            }
                            if (this.info.处理自动图集.启用) {
                                if (/\.pac\.meta$/i.test(name)) {
                                    const code = files.readStr(dirOrFilePath);
                                    if (this.info.处理自动图集.宽 > -1) {
                                        const matchArr = code.match(/"maxWidth": (\d+)/);
                                        if (matchArr) {
                                            parseInt(matchArr[1]!) == this.info.处理自动图集.宽 || this.add(i, "自动图集宽", this.info.处理自动图集.宽 + "");
                                        }
                                    }
                                    if (this.info.处理自动图集.高 > -1) {
                                        const matchArr = code.match(/"maxHeight": (\d+)/);
                                        if (matchArr) {
                                            parseInt(matchArr[1]!) == this.info.处理自动图集.高 || this.add(i, "自动图集高", this.info.处理自动图集.高 + "");
                                        }
                                    }
                                    if (this.info.处理自动图集.间距 > -1) {
                                        const matchArr = code.match(/"padding": (\d+)/);
                                        if (matchArr) {
                                            parseInt(matchArr[1]!) == this.info.处理自动图集.间距 || this.add(i, "自动图集间距", this.info.处理自动图集.间距 + "");
                                        }
                                    }
                                    switch (this.info.处理自动图集.旋转) {
                                        case "true":
                                        case "false":
                                            const matchArr = code.match(/"allowRotation": (true|false)/);
                                            if (matchArr) {
                                                matchArr[1] == this.info.处理自动图集.旋转 || this.add(i, "自动图集旋转", this.info.处理自动图集.旋转);
                                            }
                                            break;
                                    }
                                    switch (this.info.处理自动图集.正方形) {
                                        case "true":
                                        case "false":
                                            const matchArr = code.match(/"forceSquared": (true|false)/);
                                            if (matchArr) {
                                                matchArr[1] == this.info.处理自动图集.正方形 || this.add(i, "自动图集正方形", this.info.处理自动图集.正方形);
                                            }
                                            break;
                                    }
                                    switch (this.info.处理自动图集.二次幂) {
                                        case "true":
                                        case "false":
                                            const matchArr = code.match(/"powerOfTwo": (true|false)/);
                                            if (matchArr) {
                                                matchArr[1] == this.info.处理自动图集.二次幂 || this.add(i, "自动图集二次幂", this.info.处理自动图集.二次幂);
                                            }
                                            break;
                                    }
                                    switch (this.info.处理自动图集.扩边) {
                                        case "true":
                                        case "false":
                                            const matchArr = code.match(/"paddingBleed": (true|false)/);
                                            if (matchArr) {
                                                matchArr[1] == this.info.处理自动图集.扩边 || this.add(i, "自动图集扩边", this.info.处理自动图集.扩边);
                                            }
                                            break;
                                    }
                                }
                            }
                            if (this.info.处理预制体.启用) {
                                let matchArr = name.match(/^(.*)\.prefab$/i);
                                if (matchArr) {
                                    const name = matchArr[1]!;
                                    const code = files.readStr(dirOrFilePath);
                                    if (this.info.处理预制体.名字) {
                                        switch (this.pojType) {
                                            case "cc24":
                                                matchArr = code.match(/"__type__": "cc.Node",\s*"_name": "([^"]*)"/)!;
                                                name == matchArr[1] || this.add(i, "预制体名字", name);
                                                break;
                                            case "cc38":
                                                matchArr = code.match(/"__type__": "cc.Prefab",\s*"_name": "([^"]*)"/)!;
                                                if (name == matchArr[1]) {
                                                    matchArr = code.match(/"__type__": "cc.Node",\s*"_name": "([^"]*)"/)!;
                                                    name == matchArr[1] || this.add(i, "预制体名字", name);
                                                } else {
                                                    this.add(i, "预制体名字", name);
                                                }
                                                break;
                                            // case "tj1":
                                        }
                                    }
                                    switch (this.info.处理预制体.premultiplyAlpha) {
                                        case "true":
                                        case "false":
                                            if (matchArr = code.match(this.premultiplyAlphaRegG)) {
                                                for (const line of matchArr) {
                                                    matchArr = line.match(this.premultiplyAlphaReg);
                                                    if (matchArr) {
                                                        if (matchArr[2] == this.info.处理预制体.premultiplyAlpha) { } else {
                                                            this.add(i, "预制体premultiplyAlpha", this.info.处理预制体.premultiplyAlpha);
                                                            break;
                                                        }
                                                    }
                                                }
                                            }
                                            break;
                                    }
                                }
                            }
                        }
                    }

                    if (this.info.跨bundle引用) {
                        Utils.clearObj(this.filePathsByUUID);
                        for (const metaPath of files.getFilePaths(this.assetsDirPath, true, ".meta")) {
                            const filePath = metaPath.replace(/\.meta$/i, "");
                            for (const uuid of UUIDs.getUUIDs(files.readStr(metaPath))) {
                                if (this.filePathsByUUID[uuid]) {
                                    console.error("同一个 uuid（" + uuid + "）指向多个文件：\n" + this.filePathsByUUID[uuid] + "\n" + filePath);
                                } else {
                                    this.filePathsByUUID[uuid] = filePath;
                                }
                            }
                        }
                        //console.log(Utils.tryStringify(this.filePathsByUUID, undefined, "\t"));
                        Utils.clearObj(this.bundleDirPathss);
                        Utils.clearObj(this.bundleNames);
                        for (const dirPath of files.getDirPaths(this.assetsDirPath, false)) {
                            let bundleName: string = dirPath.match(/\/([^\/]+)\/$/)![1]!;
                            if (files.readStr(dirPath.replace(/\/$/, ".meta")).includes('"isBundle": true')) {
                                this.bundleNames[bundleName] = bundleName;
                            } else {
                                this.bundleNames[bundleName] = bundleName = "main";
                            }
                            let bundleDirPaths: Array<string> = this.bundleDirPathss[bundleName]!;
                            bundleDirPaths || (this.bundleDirPathss[bundleName] = bundleDirPaths = []);
                            bundleDirPaths.push(dirPath);
                        }
                        //console.log("bundleNames=", Utils.tryStringify(this.bundleNames, undefined, "\t"));
                        // bundleNames={
                        //     "0th": "main",
                        //     "1st": "1st",
                        //     "d": "main",
                        //     "resources": "resources",
                        //     "sps1": "sps1"
                        // }
                        //console.log("bundleDirPathss=", Utils.tryStringify(this.bundleDirPathss, undefined, "\t"));
                        // bundleDirPathss={
                        //     "main": [
                        //         "D:/wamp/www/qimiaosenlin/3/cc38x/hcdjs/assets/0th/",
                        //         "D:/wamp/www/qimiaosenlin/3/cc38x/hcdjs/assets/d/"
                        //     ],
                        //     "1st": [
                        //         "D:/wamp/www/qimiaosenlin/3/cc38x/hcdjs/assets/1st/"
                        //     ],
                        //     "resources": [
                        //         "D:/wamp/www/qimiaosenlin/3/cc38x/hcdjs/assets/resources/"
                        //     ],
                        //     "sps1": [
                        //         "D:/wamp/www/qimiaosenlin/3/cc38x/hcdjs/assets/sps1/"
                        //     ]
                        // }
                        for (const bundleName in this.bundleDirPathss) {
                            for (const dirPath of this.bundleDirPathss[bundleName]!) {
                                for (const prefabPath of files.getFilePaths(dirPath, true, ".fire", ".scene", ".prefab")) {
                                    for (const uuid of UUIDs.getUUIDs(files.readStr(prefabPath))) {
                                        const _filePath = this.filePathsByUUID[uuid];
                                        if (_filePath) {
                                            const filePath = _filePath.replace(this.assetsDirPath, "");
                                            const matchArr = filePath.match(/^([^\/]+)\/.+$/);
                                            const _bundleName = matchArr ? this.bundleNames[matchArr[1]!] : "main"/*直接放到 assets/ 下面的资源*/;
                                            if (bundleName == _bundleName) continue;
                                            this.add(this.dirOrFilePaths.indexOf(prefabPath), "跨bundle引用", _bundleName + " " + filePath);
                                            break;
                                        }
                                    }
                                }
                            }
                        }
                    }

                    Utils.hideLoading();
                } else {
                    outputErr("未知项目类型！");
                }
            } else {
                outputErr("无：" + this.info.poj);
            }
            this.refresh();
        };

        if (this.待修正ss) {
            const count = Object.keys(this.待修正ss).length;
            const span = this.span(count);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            if (count) {
                const btn = this.input("button");
                btn.value = "全部修正";
                btn.onclick = async () => {
                    Utils.showLoading("修正中……");
                    let i: number = -1;
                    for (const dirOrFilePath of this.dirOrFilePaths) {
                        i++;
                        const 待修正s = this.待修正ss[i];
                        if (待修正s) {
                            for (const 待修正 of 待修正s) {
                                if (待修正.fix) {
                                    await 待修正.fix();
                                }
                            }
                        }
                    }
                    Utils.hideLoading();
                };
                this.br();

                const div = this.div();
                div.style["overflow-y"] = "auto";
                div.style.height = "500px";

                const table = div.table();
                let i: number = -1;
                for (const dirOrFilePath of this.dirOrFilePaths) {
                    i++;
                    const 待修正s = this.待修正ss[i];
                    if (待修正s) {
                        const tr = table.tr();
                        tr.td(files.openLink(dirOrFilePath, 3));
                        const td = tr.td();
                        for (const 待修正 of 待修正s) {
                            this.修正按钮(td, i, 待修正);
                        }
                    }
                }
            }
        }

        this.onRefresh = () => {
            this.poj.value = this.info.poj;
            this.info.处理文件名 || (this.info.处理文件名 = {} as any);
            (this.处理文件名.checked = this.info.处理文件名.启用 || (this.info.处理文件名.启用 = false)) ? this.启用容器(this.处理文件名td) : this.禁用容器(this.处理文件名td);
            this.文件名去掉空白逗号分号.checked = this.info.处理文件名.去掉空白逗号分号 || (this.info.处理文件名.去掉空白逗号分号 = false);
            this.文件名后缀改小写.checked = this.info.处理文件名.后缀改小写 || (this.info.处理文件名.后缀改小写 = false);
            this.文件名jpeg改jpg.checked = this.info.处理文件名.jpeg改jpg || (this.info.处理文件名.jpeg改jpg = false);

            this.info.处理PNG || (this.info.处理PNG = {} as any);
            (this.处理PNG.checked = this.info.处理PNG.启用 || (this.info.处理PNG.启用 = false)) ? this.启用容器(this.处理PNGtd) : this.禁用容器(this.处理PNGtd);
            this.PNG去掉周围空白.checked = this.info.处理PNG.去掉周围空白 || (this.info.处理PNG.去掉周围空白 = false);
            this.PNG再存.checked = this.info.处理PNG.再存 || (this.info.处理PNG.再存 = false);

            this.info.处理文本 || (this.info.处理文本 = {} as any);
            (this.处理文本.checked = this.info.处理文本.启用 || (this.info.处理文本.启用 = false)) ? this.启用容器(this.处理文本td) : this.禁用容器(this.处理文本td);
            this.文本存成UTF8.checked = this.info.处理文本.存成UTF8 || (this.info.处理文本.存成UTF8 = false);

            this.info.处理纹理 || (this.info.处理纹理 = {} as any);
            (this.处理纹理.checked = this.info.处理纹理.启用 || (this.info.处理纹理.启用 = false)) ? this.启用容器(this.处理纹理td) : this.禁用容器(this.处理纹理td);
            this.纹理packable.value = this.info.处理纹理.packable || (this.info.处理纹理.packable = "不处理");
            this.纹理premultiplyAlpha.value = this.info.处理纹理.premultiplyAlpha || (this.info.处理纹理.premultiplyAlpha = "不处理");
            this.纹理trimType.value = this.info.处理纹理.trimType || (this.info.处理纹理.trimType = "不处理");

            this.info.处理自动图集 || (this.info.处理自动图集 = {} as any);
            (this.处理自动图集.checked = this.info.处理自动图集.启用 || (this.info.处理自动图集.启用 = false)) ? this.启用容器(this.处理自动图集td) : this.禁用容器(this.处理自动图集td);
            this.自动图集宽.value = this.info.处理自动图集.宽 > -1 ? this.info.处理自动图集.宽 + "" : "不处理";
            this.自动图集高.value = this.info.处理自动图集.高 > -1 ? this.info.处理自动图集.高 + "" : "不处理";
            this.自动图集间距.value = this.info.处理自动图集.间距 > -1 ? this.info.处理自动图集.间距 + "" : "不处理";
            this.自动图集旋转.value = this.info.处理自动图集.旋转 || (this.info.处理自动图集.旋转 = "不处理");
            this.自动图集正方形.value = this.info.处理自动图集.正方形 || (this.info.处理自动图集.正方形 = "不处理");
            this.自动图集二次幂.value = this.info.处理自动图集.二次幂 || (this.info.处理自动图集.二次幂 = "不处理");
            this.自动图集扩边.value = this.info.处理自动图集.扩边 || (this.info.处理自动图集.扩边 = "不处理");

            this.info.处理预制体 || (this.info.处理预制体 = {} as any);
            (this.处理预制体.checked = this.info.处理预制体.启用 || (this.info.处理预制体.启用 = false)) ? this.启用容器(this.处理预制体td) : this.禁用容器(this.处理预制体td);
            this.预制体名字.checked = this.info.处理预制体.名字 || (this.info.处理预制体.名字 = false);
            this.预制体premultiplyAlpha.value = this.info.处理预制体.premultiplyAlpha || (this.info.处理预制体.premultiplyAlpha = "不处理");

            this.跨bundle引用.checked = this.info.跨bundle引用 || (this.info.跨bundle引用 = false);
        };
    }
    private add(index: number, reason: Reason, info?: string): void {
        let 待修正s = this.待修正ss[index];
        待修正s || (待修正s = this.待修正ss[index] = []);
        待修正s.push({ reason: reason, info: info! });
    }
    private 修正按钮(td: Element, index: number, 待修正: 待修正): void {
        const btn = td.input("button");
        btn.value = 待修正.reason;
        待修正.info && (btn.value += "(" + 待修正.info + ")");
        btn.id = index + 待修正.reason;
        btn.onclick = 待修正.fix = async () => {
            await this.修正(index, 待修正);
        };
    }
    private async 修正(index: number, 待修正: 待修正) {
        const dirOrFilePath = this.dirOrFilePaths[index]!;
        let matchArr: RegExpMatchArray;
        let code: string;
        switch (待修正.reason) {
            case "文件名去掉空白逗号分号":
                if (files.isDir(dirOrFilePath)) {
                    matchArr = dirOrFilePath.match(/^(.+\/)([^\/]+\/)$/)!;
                    const fixedDirPath = matchArr[1] + matchArr[2]!.replace(/[\s,;]+/g, "");
                    files.cutDir(dirOrFilePath, fixedDirPath);
                    let i: number = this.dirOrFilePaths.length;
                    while (i--) {
                        if (this.dirOrFilePaths[i]!.startsWith(dirOrFilePath)) {
                            this.dirOrFilePaths[i] = this.dirOrFilePaths[i]!.replace(dirOrFilePath, fixedDirPath);
                        }
                    }
                } else {
                    matchArr = dirOrFilePath.match(/^(.+\/)([^\/]+)$/)!;
                    files.cutFile(dirOrFilePath, this.dirOrFilePaths[index] = matchArr[1] + matchArr[2]!.replace(/[\s,;]+/g, ""));
                }
                break;
            case "文件名后缀改小写":
                matchArr = dirOrFilePath.match(/^(.+?)((?:\.\w+)?(?:\.meta)?)$/i)!;
                files.cutFile(dirOrFilePath, this.dirOrFilePaths[index] = matchArr[1] + matchArr[2]!.toLowerCase());
                break;
            case "文件名jpeg改jpg":
                matchArr = dirOrFilePath.match(/^(.+?)\.\w+(\.meta)?$/i)!;
                files.cutFile(dirOrFilePath, this.dirOrFilePaths[index] = matchArr[1] + ".jpg" + (matchArr[2] || ""));
                break;
            case "PNG去掉周围空白":
                {
                    const sharp = await Sharps.fromFile(dirOrFilePath);
                    if (sharp.failReason) {
                        console.error(sharp.failReason);
                    } else {
                        const ltrb = Sharps.获取有效区域(await Sharps.getRGBAs(sharp.img), sharp.wid, sharp.hei);
                        if (ltrb) {
                            if (ltrb.full) { } else {
                                sharp.img.extract({ left: ltrb.l, top: ltrb.t, width: ltrb.r - ltrb.l + 1, height: ltrb.b - ltrb.t + 1 });
                                files.writeBytes(dirOrFilePath, await sharp.img.png().toBuffer());
                            }
                        }
                    }
                    sharp.img?.destroy();
                }
                break;
            case "PNG再存":
                {
                    let result: string = Converts.optimizedPNG.get(dirOrFilePath);
                    if (result) {
                        result == "original" || files.copyFile(result, dirOrFilePath);
                    } else {
                        const sharp = await Sharps.fromFile(dirOrFilePath);
                        if (sharp.failReason) {
                            console.error(sharp.failReason);
                        } else {
                            const pngBytes = await sharp.img.png().toBuffer();
                            result = Converts.optimizedPNG.mark(pngBytes.length < files.stat(dirOrFilePath).size ? pngBytes : "original", dirOrFilePath);
                            result == "original" || files.copyFile(result, dirOrFilePath);
                        }
                        sharp.img?.destroy();
                    }
                }
                break;
            case "文本存成UTF8":
                ReadWriteStr.read(dirOrFilePath);
                ReadWriteStr.write("utf8");
                break;
            case "纹理packable":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"packable": (?:true|false)/, '"packable": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "纹理premultiplyAlpha":
                code = files.readStr(dirOrFilePath);
                code = code.replace(this.premultiplyAlphaReg, '$1: ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "纹理trimType":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"trimType": "(?:auto|custom|none)"/, '"trimType": "' + 待修正.info + '"');
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集宽":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"maxWidth": (?:\d+)/, '"maxWidth": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集高":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"maxHeight": (?:\d+)/, '"maxHeight": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集间距":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"padding": (?:\d+)/, '"padding": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集旋转":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"allowRotation": (?:true|false)/, '"allowRotation": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集正方形":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"forceSquared": (?:true|false)/, '"forceSquared": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集二次幂":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"powerOfTwo": (?:true|false)/, '"powerOfTwo": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "自动图集扩边":
                code = files.readStr(dirOrFilePath);
                code = code.replace(/"paddingBleed": (?:true|false)/, '"paddingBleed": ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "预制体名字":
                code = files.readStr(dirOrFilePath);
                switch (this.pojType) {
                    case "cc24":
                        code = code.replace(/"__type__": "cc.Node",\s*"_name": "[^"]*"/, '"__type__": "cc.Node",\n    "_name": "' + 待修正.info + '"');
                        break;
                    case "cc38":
                        code = code.replace(/"__type__": "cc.Prefab",\s*"_name": "[^"]*"/, '"__type__": "cc.Prefab",\n    "_name": "' + 待修正.info + '"');
                        code = code.replace(/"__type__": "cc.Node",\s*"_name": "[^"]*"/, '"__type__": "cc.Node",\n    "_name": "' + 待修正.info + '"');
                        break;
                    // case "tj1":
                }
                files.writeStr(dirOrFilePath, code);
                break;
            case "预制体premultiplyAlpha":
                code = files.readStr(dirOrFilePath);
                code = code.replace(this.premultiplyAlphaRegG, '$1: ' + 待修正.info);
                files.writeStr(dirOrFilePath, code);
                break;
            case "跨bundle引用":
                console.error("需手动处理：" + dirOrFilePath.replace(this.assetsDirPath, "") + " " + 待修正.info);
                return;
                break;
        }
        const btn = (this as any)[index + 待修正.reason] as HTMLInputElement;
        btn.disabled = true;
        btn.value += "√";
        delete 待修正.fix;
    }
}
