import Utils from "../utils/Utils";
import files from "../utils/files";
import Page, { Element } from "./Page";

export default class extends Page {
    protected info!: any;
    private winInfo!: string;
    private pngPath!: string;
    protected _refresh(): void {
        const div = this.div();
        div.style["overflow-y"] = "auto";
        div.style.height = "300px";
        const table = div.table();
        let i: number = -1;
        for (const win of screenshot.Window.all()) {
            i++;
            const tr = table.tr();
            tr.td(win.id);
            tr.td(win.appName);
            tr.td(win.title);
            this.addCell(tr, win);
        }
        if (this.pngPath) {
            this.br();
            this.text(this.winInfo);
            this.br();
            this.img(this.pngPath);
        }
    }
    private addCell(tr: Element, win: screenshot.Window): void {
        const btn = tr.td().input("button");
        btn.value = "截屏";
        btn.onclick = () => {
            this.winInfo = win.appName + " " + win.x + ", " + win.y + " " + win.width + "x" + win.height;
            const img = win.captureImageSync();
            files.checkAndWrite(this.pngPath = Utils.appDirPath + "screenshots/window" + win.id + ".png", img.toPngSync());
            this.refresh();
        };
    }
}
