import Store, { UglifyArgs } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: UglifyArgs;
    private path!: HTMLInputElement;
    private api!: HTMLInputElement;
    private srcs!: string[];
    private dests!: string[];
    protected _refresh(): void {
        this.info.jss || (this.info.jss = Utils.appDirPath + "tests/JS/666.js");

        this.text("JS(们)：");
        const path = this.input("text");
        path.id = "path";
        path.style.width = "400px";
        this.br();

        this.text("api：");
        const api = this.select("terser", "uglifyjs");
        api.id = "api";
        api.style.width = "64px";
        api.onchange = () => {
            outputErr("");
            this.info.api = this.api.value as "terser";
            Store.flush();
        };

        const 美化 = this.input("button");
        美化.value = "美化";
        美化.onclick = this.美化;
        const 丑化 = this.input("button");
        丑化.value = "丑化";
        丑化.onclick = this.丑化;

        if ((files.isDir(this.info.jss) || files.isFile(this.info.jss)) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                tr.td(files.openLink(this.dests[i]!, 2));
            }
        }
        this.onRefresh = () => {
            this.path.value = this.info.jss;
            this.api.value = this.info.api;
        };
    }
    private 美化 = () => {
        outputErr("");
        if (files.isDir(this.path.value)) {
            this.info.jss = files.normalizeDirPath(this.path.value);
            Store.flush();
            if (this.srcs) {
                this.srcs.length = 0;
                this.dests.length = 0;
            } else {
                this.srcs = [];
                this.dests = [];
            }
            let i: number = -1;
            for (const jsPath of files.getFilePaths(this.info.jss, true, ".js")) {
                i++;
                this.beautify(this.srcs[i] = jsPath, this.dests[i] = jsPath.replace(/(\.\w+)$/, "美化$1"));
            }
            this.refresh();
        } else if (files.isFile(this.path.value)) {
            this.info.jss = files.normalizeFilePath(this.path.value);
            Store.flush();
            if (this.srcs) {
                this.srcs.length = 0;
                this.dests.length = 0;
            } else {
                this.srcs = [];
                this.dests = [];
            }
            this.beautify(this.srcs[0] = this.info.jss, this.dests[0] = this.info.jss.replace(/(\.\w+)$/, "美化$1"));
            this.refresh();
        } else {
            outputErr("无 " + this.info.jss);
        }
    }
    private 丑化 = () => {
        outputErr("");
        if (files.isDir(this.path.value)) {
            this.info.jss = files.normalizeDirPath(this.path.value);
            Store.flush();
            if (this.srcs) {
                this.srcs.length = 0;
                this.dests.length = 0;
            } else {
                this.srcs = [];
                this.dests = [];
            }
            let i: number = -1;
            for (const jsPath of files.getFilePaths(this.info.jss, true, ".js")) {
                i++;
                this.uglify(this.srcs[i] = jsPath, this.dests[i] = jsPath.replace(/(\.\w+)$/, "丑化$1"));
            }
            this.refresh();
        } else if (files.isFile(this.path.value)) {
            this.info.jss = files.normalizeFilePath(this.path.value);
            Store.flush();
            if (this.srcs) {
                this.srcs.length = 0;
                this.dests.length = 0;
            } else {
                this.srcs = [];
                this.dests = [];
            }
            this.uglify(this.srcs[0] = this.info.jss, this.dests[0] = this.info.jss.replace(/(\.\w+)$/, "丑化$1"));
            this.refresh();
        } else {
            outputErr("无 " + this.info.jss);
        }
    }
    private beautify(src: string, dest: string): void {
        const result = this.info.api == "uglifyjs" ? uglifyjs.minify(
            files.readStr(src), {
            compress: false,   // 关闭压缩
            mangle: false,     // 关闭变量混淆
            output: {
                beautify: true,        // 关键：开启美化
                indent_level: 2,       // 缩进 2 空格（可改成 4）
                comments: 'all'        // 保留所有注释
            }
        }) : minify_sync(
            files.readStr(src), {
            compress: false,   // 关闭压缩
            mangle: false,     // 关闭变量混淆
            output: {
                beautify: true,        // 关键：开启美化
                indent_level: 2,       // 缩进 2 空格（可改成 4）
                comments: 'all'        // 保留所有注释
            }
        });
        if (result?.code) {
            files.writeStr(dest, result.code);
        } else {
            outputErr("美化失败：" + Utils.tryStringify(result));
        }
    }
    private uglify(src: string, dest: string): void {
        const result = this.info.api == "uglifyjs" ? uglifyjs.minify(
            files.readStr(src)//, {
            //     compress: { drop_console: true }, // 可选配置
            //     mangle: true,
            //     output: { comments: false }
            // }
        ) : minify_sync(
            files.readStr(src)//, {
            //     compress: { drop_console: true }, // 可选配置
            //     mangle: true,
            //     output: { comments: false }
            // }
        );
        if (result?.code) {
            files.writeStr(dest, result.code);
        } else {
            outputErr("丑化失败：" + Utils.tryStringify(result));
        }
    }
}
