import CMD from "../utils/CMD";
import Store, { PathDir } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import 把zip里文件时间戳都改成固定值 from "../utils/把zip里文件时间戳都改成固定值";
import Page from "./Page";

export default class extends Page {
    protected info!: PathDir;
    private dir!: HTMLInputElement;
    private zipPath!: string;
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/压缩");

        this.text("文件们：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";
        this.br();

        const btn = this.input("button");
        btn.value = "压缩";
        btn.onclick = async () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isDir(this.info.dir)) {
                this.zipPath = this.info.dir + this.info.dir.match(/\/([^\/]+)\/$/)![1] + ".zip";
                CMD.standBy();
                CMD.deleteFile(this.zipPath);
                CMD.cd(this.info.dir);
                CMD.zip(this.zipPath);
                await CMD.run("压缩中……");
                if (files.isFile(this.zipPath)) {
                    把zip里文件时间戳都改成固定值.doo(this.zipPath);
                } else {
                    outputErr("压缩失败！");
                }
            } else {
                outputErr("无：" + this.info.dir);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.zipPath) {
            this.text(files.openLink(this.zipPath, 2));
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
        };
    }
}
