import Store, { TSUPArgs } from "../utils/Store";
import TSUP from "../utils/TSUP";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: TSUPArgs;
    private entry!: HTMLInputElement;
    private outDir!: HTMLInputElement;
    private tsconfig!: HTMLInputElement;
    private format!: HTMLInputElement;
    private minify!: HTMLInputElement;
    private clean!: HTMLInputElement;
    private es5!: HTMLInputElement;
    private result!: string;
    protected _refresh(): void {
        this.info.entry || (this.info.entry = Utils.appDirPath + "tests/JS/index.js");

        this.text("entry：");
        const entry = this.input("text");
        entry.id = "entry";
        entry.style.width = "400px";
        this.br();

        this.text("outDir：");
        const outDir = this.input("text");
        outDir.id = "outDir";
        outDir.style.width = "400px";
        this.br();

        this.text("tsconfig：");
        const tsconfig = this.input("text");
        tsconfig.id = "tsconfig";
        tsconfig.style.width = "400px";
        this.br();

        this.checkbox("minify").id = "minify";
        this.checkbox("clean").id = "clean";
        this.checkbox("es5 ").id = "es5";

        this.text("format：");
        const format = this.select("cjs", "esm", "iife");
        format.id = "format";
        format.style.width = "100px";

        const btn = this.input("button");
        btn.value = "build";
        btn.onclick = async () => {
            outputErr("");
            this.info.entry = files.normalizeFilePath(this.entry.value);
            this.info.outDir = this.outDir.value;
            this.info.tsconfig = this.tsconfig.value;
            this.info.format = this.format.value as "cjs";
            this.info.minify = this.minify.checked;
            this.info.clean = this.clean.checked;
            this.info.es5 = this.es5.checked;
            Store.flush();
            const args = Utils.deepCopy(this.info);
            const failReason = await TSUP.build(args);
            if (failReason) {
                this.result = "";
                outputErr(failReason);
            } else {
                this.result = args.result!;
            }
            this.refresh();
        };

        if (this.result) {
            this.br();
            this.text('build 成功：' + files.openLink(this.result));
        }
        this.onRefresh = () => {
            this.entry.value = this.info.entry;
            this.outDir.value = this.info.outDir || (this.info.outDir = "");
            this.tsconfig.value = this.info.tsconfig || (this.info.tsconfig = "");
            this.format.value = this.info.format || (this.info.format = "cjs");
            this.minify.checked = this.info.minify || (this.info.minify = false);
            this.clean.checked = this.info.clean || (this.info.clean = false);
            this.es5.checked = this.info.es5 || (this.info.es5 = false);
        };
    }
}
