import Entry from "../Entry";
import Store from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";

const sb: string[] = [];
let sbIndex: number;
abstract class BaseElement {
    public elements: (Element | string)[] = [];
    public onclick!: () => void;
    public text(text: string | number): void {
        this.elements.push(text as string);
    }
    private append(tag: string): Element {
        const element = new Element(tag);
        this.elements.push(element);
        return element;
    }
    public br(): Element {
        return this.append("br");
    }
    public div(): Element {
        return this.append("div");
    }
    public span(text?: string | number): Element {
        const td = this.append("span");
        text === undefined || td.text(text);
        return td;
    }
    public a(href: string): Element {
        const a = this.append("a");
        a.href = href;
        return a;
    }
    public input(type?: "text" | "button" | "radio"): Element {
        const input = this.append("input");
        type && (input.type = type);
        return input;
    }
    public label(): Element {
        return this.append("label");
    }
    public checkbox(text: string): Element {
        const label = this.label();
        const checkbox = label.input();
        checkbox.type = "checkbox";
        label.text(text);
        return checkbox;
    }
    public textarea(): Element {
        return this.append("textarea");
    }
    public table(): Element {
        return this.append("table");
    }
    public tr(): Element {
        return this.append("tr");
    }
    public td(text?: string | number): Element {
        const td = this.append("td");
        text === undefined || td.text(text);
        return td;
    }
    public select(...values: string[]): Element {
        const select = this.append("select");
        for (const value of values) {
            select.append("option").text(value);
        }
        return select;
    }
    public radios(name: string, selected: string, ...values: string[]): Element {
        const span = this.span();
        for (const value of values) {
            const label = span.label();
            const radio = label.input("radio");
            radio.name = name;
            radio.value = value;
            if (value == selected) {
                radio.checked = true;
            }
            label.text(value);
        }
        return span;
    }
    public 点击复制单元格内容(str: string): void {
        this.text(Utils.如果太长了加省略号(str, 64));
        this.onclick = () => {
            Utils.writeClipboard(str);
            Utils.successMsg("已复制 " + str.length + "字符 到剪贴板！");
        };
    }
    public img(src?: string): Element {
        const img = this.append("img");
        src && (img.src = src);
        return img;
    }
}
export default abstract class extends BaseElement {
    public name!: string;
    protected abstract info: any;
    private ids!: string[];
    private funs!: (() => void)[];
    protected onRefresh!: () => void;
    public show(): void {
        (window as any).runFun = (index: number) => {
            this.funs[index]!();
        };
        this.info = (Store as any)[this.name];
        //console.log("info=", this.info);
        this.ids = [];
        this.funs = [];
        this.refresh();
    }
    private addBtn(pageName: string): void {
        const btn = this.input("button");
        btn.value = pageName;
        if (pageName == this.name) {
            btn.style.color = "brown";
            btn.style["font-weight"] = "bold";
        }
        btn.onclick = () => { Entry.跳页(pageName); };
    }
    protected refresh = () => {
        this.elements.length = 0;

        for (const pageName in Entry.pageClasses) {
            this.addBtn(pageName);
        }
        this.br();
        this.text(files.openLink(Utils.appDirPath + "source/src/pages/" + this.name + ".ts", 3));
        this.br();
        this.br();
        this._refresh();
        sb.length = 0;
        sbIndex = 0;
        for (const id of this.ids) {
            delete (this as any)[id];
        }
        this.ids.length = 0;
        this.funs.length = 0;
        this.拼HTML(this.elements);
        outputHTML(sb.join(""), () => {
            //console.log("this.ids=" + this.ids);
            for (const id of this.ids) {
                (this as any)[id] = document.getElementById(id);
            }
            if (this.onRefresh) {
                this.onRefresh();
                this.onRefresh = undefined!;
            }
        });
    }
    protected abstract _refresh(): void;
    private 拼HTML(elements: (Element | string)[]): void {
        for (const element of elements) {
            if (element instanceof Element) {
                sb[sbIndex++] = '<';
                sb[sbIndex++] = element.tag;
                for (const key in element) {
                    switch (key) {
                        case "tag":
                        case "elements":
                            break;
                        default:
                            const value = (element as any)[key];
                            switch (typeof (value)) {
                                case "undefined":
                                    break;
                                case "function":
                                    sb[sbIndex++] = ' ';
                                    sb[sbIndex++] = key;
                                    sb[sbIndex++] = '="runFun(';
                                    sb[sbIndex++] = this.funs.length as any;
                                    sb[sbIndex++] = ')"';
                                    this.funs.push(value);
                                    break;
                                case "object":
                                    const keys = Object.keys(value);
                                    if (keys.length) {
                                        sb[sbIndex++] = ' ';
                                        sb[sbIndex++] = key;
                                        sb[sbIndex++] = '="';
                                        for (const key of keys) {
                                            sb[sbIndex++] = key;
                                            sb[sbIndex++] = ':';
                                            sb[sbIndex++] = value[key];
                                            sb[sbIndex++] = ';';
                                        }
                                        sb[sbIndex++] = '"';
                                    }
                                    break;
                                default:
                                    sb[sbIndex++] = ' ';
                                    sb[sbIndex++] = key;
                                    sb[sbIndex++] = '="';
                                    sb[sbIndex++] = value;
                                    sb[sbIndex++] = '"';
                                    if (key == "id") {
                                        this.ids.push(value);
                                    }
                                    break;
                            }
                            break;
                    }
                }
                if (element.elements.length) {
                    sb[sbIndex++] = '>';
                    this.拼HTML(element.elements);
                    sb[sbIndex++] = '</';
                    sb[sbIndex++] = element.tag;
                    sb[sbIndex++] = '>';
                } else {
                    switch (element.tag) {
                        case "textarea":
                            sb[sbIndex++] = '></textarea>';
                            break;
                        default:
                            sb[sbIndex++] = '/>';
                            break;
                    }
                }
            } else {
                sb[sbIndex++] = element;
            }
        }
    }
    protected 启用容器(container: HTMLElement): void {
        container.style.pointerEvents = "auto";
        container.style.opacity = "1";
        container.style.cursor = "auto";
    }
    protected 禁用容器(container: HTMLElement): void {
        container.style.pointerEvents = "none";
        container.style.opacity = "0.6";
        container.style.cursor = "not-allowed";
    }
}
export class Element extends BaseElement {
    public tag: string;
    public id!: string;
    public name!: string;
    public type!: string;
    public value!: string;
    public oninput!: () => void;
    public onchange!: () => void;
    public href!: string;
    public rows!: number;
    public checked!: boolean;
    public src!: string;
    public style: {
        width: string;
        height: string;
        color: string;
        "font-weight": "bold";
        "overflow-y": "auto";
    } = {} as any;
    public constructor(tag: string) {
        super();
        this.tag = tag;
    }
}