import PNG8 from "../utils/PNG8";
import Store, { PathDir } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: PathDir;
    private dir!: HTMLInputElement;
    private srcs!: string[];
    private sizes!: number[];
    private results!: string[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/图片们");

        this.text("待压缩的PNG们：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";
        this.br();

        const btn = this.input("button");
        btn.value = "压缩";
        btn.onclick = async () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isDir(this.info.dir)) {
                if (this.srcs) {
                    this.srcs.length = 0;
                    this.sizes.length = 0;
                    this.results.length = 0;
                } else {
                    this.srcs = [];
                    this.sizes = [];
                    this.results = [];
                }
                let i: number = -1;
                for (const filePath of files.getFilePaths(this.info.dir, true, ".png")) {
                    i++;
                    this.srcs[i] = filePath;
                    this.sizes[i] = files.stat(filePath).size;
                    this.results[i] = await PNG8.doo(filePath);
                }
            } else {
                outputErr("无：" + this.info.dir);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                const result = this.results[i];
                const span = tr.td().span();
                if (result) {
                    span.style.color = "red";
                    span.text(result);
                } else {
                    span.style.color = "green";
                    span.text('压缩率 ' + Utils.百分数(files.stat(src).size / this.sizes[i]!));
                }
            }
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
        };
    }
}
