import PNG24 from "../utils/PNG24";
import Store, { PNG24Args } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: PNG24Args;
    private dir!: HTMLInputElement;
    private 调整尺寸!: HTMLInputElement;
    private value!: HTMLInputElement;
    private 去掉周围空白!: HTMLInputElement;
    private srcs!: string[];
    private sizes!: number[];
    private results!: string[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/图片们");

        this.text("PNG们：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";
        this.br();

        this.text("调整尺寸：");
        const 调整尺寸 = this.select("无", "限宽", "限高", "百分比");
        调整尺寸.id = "调整尺寸";
        调整尺寸.style.width = "70px";
        调整尺寸.onchange = () => {
            this.info.调整尺寸 = this.调整尺寸.value as "无";
            Store.flush();
            this.refresh();
        };
        switch (this.info.调整尺寸) {
            case "限宽":
            case "限高":
            case "百分比":
                const value = this.input("text");
                value.id = "value";
                value.style.width = "60px";
                value.onchange = () => {
                    switch (this.info.调整尺寸) {
                        case "限宽":
                        case "限高":
                            this.info.wh = Math.round(parseFloat(this.value.value));
                            this.info.wh > 0 || (this.info.wh = 1);
                            break;
                        case "百分比":
                            this.info.p = parseFloat(this.value.value.replace(/[^\.\d]+/g, "")) / 100;
                            this.info.p > 0 || (this.info.p = 0);
                            break;
                        default:
                            break;
                    }
                    Store.flush();
                    this.refresh();
                };
                break;
            default:
                this.info.调整尺寸 = "无";
                break;
        }
        const 去掉周围空白 = this.checkbox("去掉周围空白");
        去掉周围空白.id = "去掉周围空白";
        去掉周围空白.onchange = () => {
            this.info.去掉周围空白 = this.去掉周围空白.checked;
            Store.flush();
        };

        const btn = this.input("button");
        btn.value = "处理";
        btn.onclick = async () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isDir(this.info.dir)) {
                if (this.srcs) {
                    this.srcs.length = 0;
                    this.sizes.length = 0;
                    this.results.length = 0;
                } else {
                    this.srcs = [];
                    this.sizes = [];
                    this.results = [];
                }
                PNG24.set(this.info);
                let i: number = -1;
                for (const filePath of files.getFilePaths(this.info.dir, true, ".png")) {
                    i++;
                    this.srcs[i] = filePath;
                    this.sizes[i] = files.stat(filePath).size;
                    this.results[i] = await PNG24.doo(filePath);
                }
            } else {
                outputErr("无：" + this.info.dir);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                const result = this.results[i];
                const span = tr.td().span();
                if (result) {
                    span.style.color = "red";
                    span.text(result);
                } else {
                    span.style.color = "green";
                    span.text('压缩率 ' + Utils.百分数(files.stat(src).size / this.sizes[i]!));
                }
            }
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
            this.调整尺寸.value = this.info.调整尺寸;
            switch (this.info.调整尺寸) {
                case "限宽":
                case "限高":
                    this.value.value = this.info.wh + "";
                    break;
                case "百分比":
                    this.value.value = Utils.百分数(this.info.p);
                    break;
                default:
                    break;
            }
            this.去掉周围空白.checked = this.info.去掉周围空白 || (this.info.去掉周围空白 = false);
        };
    }
}
