import MD5 from "../utils/MD5";
import Store, { PageInfo } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: PageInfo;
    private txt1!: HTMLInputElement;
    private txt2!: HTMLInputElement;
    private dir!: HTMLInputElement;
    private srcs!: string[];
    private results!: string[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/编解码");

        const txt1 = this.textarea();
        txt1.id = "txt1";
        txt1.rows = 4;
        txt1.style.width = "400px";
        txt1.oninput = this.摘要;

        this.span(" >>> ").style.color = "green";

        const txt2 = this.input("text");
        txt2.id = "txt2";
        txt2.style.width = "300px";

        this.br();

        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";

        const btn = this.input("button");
        btn.value = "摘要";
        btn.onclick = () => {
            outputErr("");
            let dirPath: string = this.dir.value;
            if (files.isDir(dirPath)) {
                if (this.srcs) {
                    this.srcs.length = 0;
                    this.results.length = 0;
                } else {
                    this.srcs = [];
                    this.results = [];
                }
                this.info.dir = dirPath = files.normalizeDirPath(dirPath);
                Store.flush();
                let i: number = -1;
                for (const filePath of files.getFilePaths(dirPath, true)) {
                    i++;
                    this.srcs[i] = filePath;
                    this.results[i] = MD5.md5(files.readBytes(filePath));
                }
            } else {
                outputErr("无 " + dirPath);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                tr.td().点击复制单元格内容(this.results[i]!);
            }
        }
        this.onRefresh = () => {
            this.txt1.value = this.info.str;
            this.dir.value = this.info.dir;
            this.摘要();
        };
    }
    private 摘要 = () => {
        outputErr("");
        this.txt2.value = MD5.md5(this.info.str = this.txt1.value);
        Store.flush();
    }
}
