import Store, { PathDir } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: PathDir;
    private dir!: HTMLInputElement;
    private srcs!: string[];
    private results!: string[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/Excels");

        this.text("Excel们：");

        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";

        const btn = this.input("button");
        btn.value = "转换";
        btn.onclick = async () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isDir(this.info.dir)) {
                if (this.srcs) {
                    this.srcs.length = 0;
                    this.results.length = 0;
                } else {
                    this.srcs = [];
                    this.results = [];
                }
                let i: number = -1;
                for (const filePath of files.getFilePaths(this.info.dir, true, ".xlsx")) {
                    i++;
                    this.srcs[i] = filePath;
                    const wb = xlsx.read(files.readBytes(filePath));
                    const ws = wb.Sheets[wb.SheetNames[0]!];
                    if (ws) {
                        files.writeStr(filePath.replace(/\.xlsx$/, ".json"), Utils.tryStringify(xlsx.utils.sheet_to_json(ws, {
                            //range: 'A1:DX65536',//很慢
                            header: 1,        // 关键：1 表示“按列顺序返回二维数组”
                            //defval: '',       // 空单元格默认填 ''
                            raw: false        // 让数字、日期都先变成字符串
                        }), undefined, "\t"));
                    } else {
                        this.results[i] = "无 sheet";
                    }
                }
            } else {
                outputErr("无：" + this.info.dir);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                const result = this.results[i];
                if (result) {
                    tr.td().span(result).style.color = "red";
                } else {
                    tr.td(files.openLink(src.replace(/\.\w+$/, ".json"), 2));
                }
            }
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
        };
    }
}
