import BMFont from "../utils/BMFont";
import Store, { DirDir } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import 项目类型, { PojType } from "../utils/项目类型";
import Page from "./Page";

export default class extends Page {
    protected info!: DirDir;
    private dir!: HTMLInputElement;
    private dir2!: HTMLInputElement;
    private pojType!: PojType;
    private confs!: string[];
    private fnts!: string[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/BMFont/位图字体");
        this.info.dir2 == "未指定" && (this.info.dir2 = Utils.appDirPath + "tests/BMFont/cc24");

        this.text("位图字体：");
        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";

        this.br();

        this.text("项目：");
        const dir2 = this.input("text");
        dir2.id = "dir2";
        dir2.style.width = "400px";
        dir2.onchange = () => {
            outputErr("");
            this.info.dir2 = this.dir2.value;
            Store.flush();
            this.refresh();
        };
        if (this.info.dir2) {
            this.info.dir2 = files.normalizeDirPath(this.info.dir2);
            if (files.isDir(this.info.dir2)) {
                this.pojType = 项目类型.getType(this.info.dir2);
            } else {
                this.pojType = undefined!;
            }
        } else {
            this.info.dir2 = "";
            this.pojType = undefined!;
        }
        this.pojType && this.text("项目类型：" + this.pojType);
        this.br();

        const btn = this.input("button");
        btn.value = "生成";
        btn.onclick = async () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isDir(this.info.dir)) {
                if (this.info.dir2 && !files.isDir(this.info.dir2)) {
                    outputErr("无：" + this.info.dir2);
                } else {
                    if (this.confs) {
                        this.confs.length = 0;
                        this.fnts.length = 0;
                    } else {
                        this.confs = [];
                        this.fnts = [];
                    }
                    const failReason = await BMFont.gen(this.info.dir, this.info.dir2, this.pojType, this.confs, this.fnts);
                    if (failReason) {
                        outputErr(failReason);
                    }
                }
            } else {
                outputErr("无：" + this.info.dir);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.confs) {
            const span = this.span(this.confs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const conf of this.confs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(conf, 2));
                tr.td(" >>> ");
                tr.td(files.openLink(this.fnts[i]!, 2));
            }
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
            this.dir2.value = this.info.dir2;
        };
    }
}
