import CMD from "../utils/CMD";
import Converts from "../utils/Converts";
import Store, { PathDir } from "../utils/Store";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: PathDir;
    private dir!: HTMLInputElement;
    private srcs!: string[];
    private results!: string[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/图片们");

        this.text("图片们：");

        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";

        const btn = this.input("button");
        btn.value = "转换";
        btn.onclick = async () => {
            outputErr("");
            this.info.dir = files.normalizeDirPath(this.dir.value);
            Store.flush();
            if (files.isDir(this.info.dir)) {
                if (this.srcs) {
                    this.srcs.length = 0;
                    this.results.length = 0;
                } else {
                    this.srcs = [];
                    this.results = [];
                }
                let i: number = -1;
                CMD.standBy();
                let has: boolean = false;
                for (const filePath of files.getFilePaths(this.info.dir, true, ".jpg", ".jpeg", ".png")) {
                    i++;
                    this.srcs[i] = filePath;
                    if (Converts.img2astc.get(filePath)) continue;
                    CMD.img2astc(filePath, 6, filePath.replace(/\.\w+$/, ".astc"));
                    has = true;
                }
                has && await CMD.run("转换ASTC中……");
                i = -1;
                for (const filePath of this.srcs) {
                    i++;
                    const result = Converts.img2astc.get(filePath);
                    const destPath = filePath.replace(/\.\w+$/, ".astc");
                    if (result) {
                        files.copyFile(result, destPath);
                    } else {
                        if (files.isFile(destPath)) {
                            Converts.img2astc.mark(destPath);
                        } else {
                            this.results[i] = "转换失败！";
                        }
                    }
                }
            } else {
                outputErr("无：" + this.info.dir);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                const result = this.results[i];
                if (result) {
                    tr.td().span(result).style.color = "red";
                } else {
                    tr.td(files.openLink(src.replace(/\.\w+$/, ".astc"), 2));
                }
            }
        }
        this.onRefresh = () => {
            this.dir.value = this.info.dir;
        };
    }
}
