import AES from "../utils/AES";
import Hex from "../utils/Hex";
import Store, { AESInfo } from "../utils/Store";
import UTF8 from "../utils/UTF8";
import Utils from "../utils/Utils";
import files from "../utils/files";
import Page from "./Page";

export default class extends Page {
    protected info!: AESInfo;
    private key!: HTMLInputElement;
    private iv!: HTMLInputElement;
    private txt1!: HTMLInputElement;
    private op!: HTMLElement;
    private txt2!: HTMLInputElement;
    private dir!: HTMLInputElement;
    private srcs!: string[];
    private results!: Uint8Array[];
    protected _refresh(): void {
        this.info.dir || (this.info.dir = Utils.appDirPath + "tests/编解码");

        this.text("key：");

        const key = this.input("text");
        key.id = "key";
        key.style.width = "100px";
        key.oninput = this.加密;

        const iv = this.input("text");
        iv.id = "iv";
        iv.style.width = "100px";
        iv.oninput = this.加密;

        const table = this.table();

        let tr = table.tr();
        tr.td("原文：");
        tr.td();
        tr.td("AES：");

        tr = table.tr();
        let td = tr.td();
        const txt1 = td.textarea();
        txt1.id = "txt1";
        txt1.rows = 8;
        txt1.style.width = "250px";
        txt1.oninput = this.加密;
        td = tr.td();
        const op = td.span();
        op.id = "op";
        op.style.color = "green";
        td = tr.td();
        const txt2 = td.textarea();
        txt2.id = "txt2";
        txt2.rows = 8;
        txt2.style.width = "250px";
        txt2.oninput = this.解密;

        this.br();


        const dir = this.input("text");
        dir.id = "dir";
        dir.style.width = "400px";

        const btn = this.input("button");
        btn.value = "加密";
        btn.onclick = () => {
            outputErr("");
            let dirPath: string = this.dir.value;
            if (files.isDir(dirPath)) {
                if (this.srcs) {
                    this.srcs.length = 0;
                    this.results.length = 0;
                } else {
                    this.srcs = [];
                    this.results = [];
                }
                this.info.dir = dirPath = files.normalizeDirPath(dirPath);
                Store.flush();
                const key = UTF8.encode(this.info.key);
                const iv = UTF8.encode(this.info.iv);
                let i: number = -1;
                for (const filePath of files.getFilePaths(dirPath, true)) {
                    i++;
                    this.srcs[i] = filePath;
                    this.results[i] = AES.encrypt(files.readBytes(filePath), key, iv);
                }
            } else {
                outputErr("无 " + dirPath);
            }
            this.refresh();
        };

        if (files.isDir(this.info.dir) && this.srcs) {
            const span = this.span(this.srcs.length);
            span.style.color = "green";
            span.style["font-weight"] = "bold";

            this.text("个文件");

            this.br();

            const div = this.div();
            div.style["overflow-y"] = "auto";
            div.style.height = "500px";

            const table = div.table();
            let i: number = -1;
            for (const src of this.srcs) {
                i++;
                const tr = table.tr();
                tr.td(files.openLink(src, 2));
                tr.td(" >>> ");
                tr.td().点击复制单元格内容(Hex.bytes2str(this.results[i]!));
            }
        }
        this.onRefresh = () => {
            this.key.value = this.info.key;
            this.iv.value = this.info.iv;
            this.txt1.value = this.info.str;
            this.dir.value = this.info.dir;
            this.加密();
        };
    }
    private 加密 = () => {
        outputErr("");
        this.op.innerText = "加密>>>";
        this.txt2.value = Hex.bytes2str(AES.encrypt(
            this.info.str = this.txt1.value,
            this.info.key = this.key.value,
            this.info.iv = this.iv.value
        ));
        Store.flush();
    }
    private 解密 = () => {
        outputErr("");
        this.op.innerText = "<<<解密";
        this.txt1.value = this.info.str = UTF8.decode(AES.decrypt(Hex.str2bytes(this.txt2.value), this.info.key, this.info.iv));
        Store.flush();
    }
}
