declare function outputMsg(_msg: string): void;
declare function outputErr(_err: string): void;
declare function outputHTML(_html: string, complete: () => void): void;

namespace shell {
    declare function openPath(path: string): void;
    declare function showItemInFolder(path: string): void;
}

namespace iconv {
    declare function encode(str: string, encoding: "gbk"): Buffer;
    declare function decode(bytes: Buffer, encoding: "gbk"): string;
}

namespace lz4 {
    export function encodeBound(inputSize: number): number;
    export function encodeBlockHC(input: Buffer, output: Buffer, compressionLevel?: number): number;
    export function decodeBlock(input: Buffer, output: Buffer, startIdx?: number, endIdx?: number): number;
}

declare function v4(): string;

namespace uglifyjs {
    export function minify(files: string | string[] | { [file: string]: string }, options?: MinifyOptions): MinifyOutput;
}

declare function minify_sync(files: string | string[] | { [file: string]: string }, options?: MinifyOptions): MinifyOutput;

declare function execFile(
    file: string,
    args: readonly string[] | undefined | null,
    options: ExecFileOptionsWithBufferEncoding,
    callback: (error: ExecFileException | null, stdout: Buffer, stderr: Buffer) => void,
): ChildProcess;

interface tsupOptions { entry: string[], outDir: string, tsconfig: string, minify: true, clean: true, format?: 'cjs' | 'esm' | 'iife', target?: "es5", async onSuccess: () => void }
namespace tsup {
    declare async function build(options: tsupOptions): Promise<void>;
}

namespace screenshot {
    declare class Monitor {
        public static all(): Monitor[];
        public id: number;
        public captureImageSync(): Image;
    }
    declare class Window {
        public static all(): Window[];
        public id: number;
        public appName: string;
        public title: string;
        public x: number;
        public y: number;
        public width: number;
        public height: number;
        public captureImageSync(): Image;
    }
    declare class Image {
        public toPngSync(): Uint8Array;
    }
}