import Page from "./pages/Page";
import BMFont from "./utils/BMFont";
import CheckChanges from "./utils/CheckChanges";
import Converts from "./utils/Converts";
import ScreenShots from "./utils/ScreenShots";
import Store from "./utils/Store";
import Utils from "./utils/Utils";
import tempFiles from "./utils/tempFiles";
import 编译Source from "./utils/编译Source";

export default new class {
    public pageClasses!: { [key: string]: any };
    public init(pageClasses: { [key: string]: any }): void {
        Utils.init();
        Store.init(Utils.appDirPath + "settings/storages/store.json");
        tempFiles.init(Utils.appDirPath + "temps/");
        Converts.init(Utils.appDirPath + "converts/");
        CheckChanges.init(Utils.appDirPath + "settings/changes/");
        BMFont.init(Utils.exesPath + "bmfont64.exe");
        if (编译Source.doo()) { } else {
            ScreenShots.init();
            outputMsg("");
            this.pageClasses = pageClasses;
            (window as any).Entry = this;
            this.跳页(pageClasses[Store.pageName] ? Store.pageName : Object.keys(pageClasses)[0]!);
        }
    }
    public 跳页(pageName: string): void {
        const clazz = this.pageClasses[pageName];
        if (clazz) {
            const page: Page = new clazz();
            Store.pageName = page.name = pageName;
            Store.flush();
            page.show();
        } else {
            outputErr("无页面：" + pageName);
        }
    }
}