import { sprite首次初始化完毕执行 } from "../Script/utils";

const { ccclass, property } = cc._decorator;

const SEGMENT_LEN = 20;
const ANGLE_SPEED = Math.PI / 10;

@ccclass
export default class Test extends cc.Component {

    private sp: cc.Sprite;
    private circle1: cc.Node;
    private circle2: cc.Node;
    private debug: cc.Graphics;
    private sw: number;
    private sh: number;
    private w02: number;
    private h02: number;
    private ps: Array<Array<number>>;

    protected onLoad(): void {

        this.sp = this.node.getChildByName("sp").getComponent(cc.Sprite);
        this.circle1 = this.node.getChildByName("circle1");
        this.circle2 = this.node.getChildByName("circle2");
        this.debug = this.node.getChildByName("debug").getComponent(cc.Graphics);

        this.sw = cc.winSize.width;
        this.sh = cc.winSize.height;
        this.w02 = this.sp.node.width / 2;
        this.h02 = this.sp.node.height / 2;
        this.sp.node.width = this.sw;
        this.sp.node.height = this.sh;
        this.ps = [[this.circle1.x, this.circle1.y], [this.circle1.x + SEGMENT_LEN, this.circle1.y]];
        sprite首次初始化完毕执行(this.sp, () => {
            this.sp.spriteFrame.vertices = {
                x: [],
                y: [],
                nu: [],
                nv: [],
                triangles: []
            }
        });

        let oldP: cc.Vec2;
        const touch_start = (evt: cc.Event.EventTouch) => {
            oldP = evt.getLocation();
        };
        this.circle2.on(cc.Node.EventType.TOUCH_START, touch_start);
        this.circle2.on(cc.Node.EventType.TOUCH_MOVE, (evt: cc.Event.EventTouch) => {
            const p = evt.getLocation();
            this.circle2.x += p.x - oldP.x;
            this.circle2.y += p.y - oldP.y;
            oldP = p;
        });

    }

    protected update(): void {

        this.debug.clear();
        this.debug.circle(this.circle2.x, this.circle2.y, 2);
        this.debug.stroke();

        const vertices = this.sp.spriteFrame.vertices;

        const lastP = this.ps[this.ps.length - 1];
        const last2P = this.ps[this.ps.length - 2];
        const v2ForwardX = lastP[0] - last2P[0];
        const v2ForwardY = lastP[1] - last2P[1];
        let v2AimX: number = this.circle2.x - lastP[0];
        let v2AimY: number = this.circle2.y - lastP[1];

        let fAngle = Math.atan2(v2ForwardY, v2ForwardX);

        //1
        // if (v2ForwardX * v2AimY - v2ForwardY * v2AimX > 0) {
        //     fAngle += ANGLE_SPEED;
        // } else {
        //     fAngle -= ANGLE_SPEED;
        // }

        //2
        const fLength = Math.sqrt(v2AimX * v2AimX + v2AimY * v2AimY);
        v2AimX /= fLength;
        v2AimY /= fLength;
        const fCross = v2ForwardX * v2AimY - v2ForwardY * v2AimX;
        fAngle += ANGLE_SPEED * fCross / SEGMENT_LEN;

        this.ps.push([lastP[0] + Math.cos(fAngle) * SEGMENT_LEN, lastP[1] + Math.sin(fAngle) * SEGMENT_LEN]);
        let j: number = vertices.x.length;
        let k: number = j / 4 * 6;
        for (let i: number = j / 4; i < this.ps.length - 1; i++) {
            let jx: number = this.ps[i][1] - this.ps[i + 1][1];
            let jy: number = this.ps[i + 1][0] - this.ps[i][0];
            const _k = 6 / Math.sqrt(jx * jx + jy * jy);
            jx *= _k;
            jy *= _k;
            vertices.x[j] = this.w02 * (1 + 2 / this.sw * (this.ps[i][0] + jx));
            vertices.y[j] = this.h02 * (1 - 2 / this.sh * (this.ps[i][1] + jy));
            vertices.x[j + 1] = this.w02 * (1 + 2 / this.sw * (this.ps[i][0] - jx));
            vertices.y[j + 1] = this.h02 * (1 - 2 / this.sh * (this.ps[i][1] - jy));
            vertices.x[j + 2] = this.w02 * (1 + 2 / this.sw * (this.ps[i + 1][0] + jx));
            vertices.y[j + 2] = this.h02 * (1 - 2 / this.sh * (this.ps[i + 1][1] + jy));
            vertices.x[j + 3] = this.w02 * (1 + 2 / this.sw * (this.ps[i + 1][0] - jx));
            vertices.y[j + 3] = this.h02 * (1 - 2 / this.sh * (this.ps[i + 1][1] - jy));
            vertices.nu[j] = 0; vertices.nv[j] = 0;
            vertices.nu[j + 1] = 0; vertices.nv[j + 1] = 1;
            vertices.nu[j + 2] = 1; vertices.nv[j + 2] = 0;
            vertices.nu[j + 3] = 1; vertices.nv[j + 3] = 1;
            vertices.triangles[k++] = j;
            vertices.triangles[k++] = j + 2;
            vertices.triangles[k++] = j + 3;
            vertices.triangles[k++] = j + 3;
            vertices.triangles[k++] = j + 1;
            vertices.triangles[k++] = j;
            j += 4;
        }

        this.sp.setVertsDirty();

    }

}
