import { sprite首次初始化完毕执行 } from "../Script/utils";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    private sp: cc.Sprite;
    private circle1: cc.Node;
    private circle2: cc.Node;
    private debug: cc.Graphics;
    private sw: number;
    private sh: number;
    private w02: number;
    private h02: number;

    protected onLoad(): void {

        this.sp = this.node.getChildByName("sp").getComponent(cc.Sprite);
        this.circle1 = this.node.getChildByName("circle1");
        this.circle2 = this.node.getChildByName("circle2");
        this.debug = this.node.getChildByName("debug").getComponent(cc.Graphics);

        this.sw = cc.winSize.width;
        this.sh = cc.winSize.height;
        this.w02 = this.sp.node.width / 2;
        this.h02 = this.sp.node.height / 2;
        this.sp.node.width = this.sw;
        this.sp.node.height = this.sh;
        sprite首次初始化完毕执行(this.sp, () => {
            this.sp.spriteFrame.vertices = {
                x: [],
                y: [],
                nu: [],
                nv: [],
                triangles: []
            }
            this.draw();
        });

        let oldP: cc.Vec2;
        const touch_start = (evt: cc.Event.EventTouch) => {
            oldP = evt.getLocation();
        };
        const touch_move = (evt: cc.Event.EventTouch) => {
            const p = evt.getLocation();
            evt.target.x += p.x - oldP.x;
            evt.target.y += p.y - oldP.y;
            oldP = p;
            this.draw();
        };
        this.circle1.on(cc.Node.EventType.TOUCH_START, touch_start);
        this.circle1.on(cc.Node.EventType.TOUCH_MOVE, touch_move);
        this.circle2.on(cc.Node.EventType.TOUCH_START, touch_start);
        this.circle2.on(cc.Node.EventType.TOUCH_MOVE, touch_move);

    }

    private draw(): void {
        this.debug.clear();
        this.debug.circle(this.circle1.x, this.circle1.y, 2);
        this.debug.circle(this.circle2.x, this.circle2.y, 2);
        this.debug.moveTo(this.circle1.x, this.circle1.y);
        this.debug.lineTo(this.circle2.x, this.circle2.y);
        this.debug.stroke();

        const vertices = this.sp.spriteFrame.vertices;
        vertices.x.length = 0;
        vertices.y.length = 0;
        vertices.nu.length = 0;
        vertices.nv.length = 0;
        vertices.triangles.length = 0;

        const dx = this.circle2.x - this.circle1.x;
        const dy = this.circle2.y - this.circle1.y;
        const r = Math.sqrt(dx * dx + dy * dy);
        let nDivideNum: number = Math.round(Math.PI * 2 * r / 10);
        if (nDivideNum < 1) nDivideNum = 4;
        else if (nDivideNum > 1000) nDivideNum = 1000;
        const r1 = r - 6;
        const r2 = r + 6;
        let j: number = 0;
        let k: number = 0;
        for (let i: number = 0; i < nDivideNum; i++) {
            const rad1 = Math.PI * 2 * i / nDivideNum;
            const rad2 = Math.PI * 2 * (i + 1) / nDivideNum;
            const c1 = Math.cos(rad1);
            const s1 = Math.sin(rad1);
            const c2 = Math.cos(rad2);
            const s2 = Math.sin(rad2);
            vertices.x[j] = this.w02 * (1 + 2 / this.sw * (this.circle1.x + r1 * c2));
            vertices.y[j] = this.h02 * (1 - 2 / this.sh * (this.circle1.y + r1 * s2));
            vertices.x[j + 1] = this.w02 * (1 + 2 / this.sw * (this.circle1.x + r2 * c2));
            vertices.y[j + 1] = this.h02 * (1 - 2 / this.sh * (this.circle1.y + r2 * s2));
            vertices.x[j + 2] = this.w02 * (1 + 2 / this.sw * (this.circle1.x + r1 * c1));
            vertices.y[j + 2] = this.h02 * (1 - 2 / this.sh * (this.circle1.y + r1 * s1));
            vertices.x[j + 3] = this.w02 * (1 + 2 / this.sw * (this.circle1.x + r2 * c1));
            vertices.y[j + 3] = this.h02 * (1 - 2 / this.sh * (this.circle1.y + r2 * s1));
            vertices.nu[j] = 0; vertices.nv[j] = 0;
            vertices.nu[j + 1] = 1; vertices.nv[j + 1] = 0;
            vertices.nu[j + 2] = 0; vertices.nv[j + 2] = 1;
            vertices.nu[j + 3] = 1; vertices.nv[j + 3] = 1;
            vertices.triangles[k++] = j;
            vertices.triangles[k++] = j + 1;
            vertices.triangles[k++] = j + 3;
            vertices.triangles[k++] = j + 3;
            vertices.triangles[k++] = j + 2;
            vertices.triangles[k++] = j;
            j += 4;
        }

        this.sp.setVertsDirty();

    }

}
