import { sprite首次初始化完毕执行 } from "../Script/utils";

const { ccclass, property } = cc._decorator;

@ccclass
export default class Test extends cc.Component {

    private sp: cc.Sprite;
    private circle1: cc.Node;
    private circle2: cc.Node;
    private debug: cc.Graphics;
    private sw: number;
    private sh: number;
    private w02: number;
    private h02: number;
    private vertices: Array<Array<number>>;

    protected onLoad(): void {

        this.sp = this.node.getChildByName("sp").getComponent(cc.Sprite);
        this.circle1 = this.node.getChildByName("circle1");
        this.circle2 = this.node.getChildByName("circle2");
        this.debug = this.node.getChildByName("debug").getComponent(cc.Graphics);

        this.sw = cc.winSize.width;
        this.sh = cc.winSize.height;
        this.w02 = this.sp.node.width / 2;
        this.h02 = this.sp.node.height / 2;
        this.sp.node.width = this.sw;
        this.sp.node.height = this.sh;
        this.vertices = [
            [-this.w02, this.h02],
            [this.w02, this.h02],
            [-this.w02, -this.h02],
            [this.w02, -this.h02]
        ];
        sprite首次初始化完毕执行(this.sp, () => {
            this.sp.spriteFrame.vertices = {
                x: [],
                y: [],
                nu: [0, 1, 0, 1],
                nv: [0, 0, 1, 1],
                triangles: [0, 1, 3, 3, 2, 0]
            }
            this.draw();
        });

        let oldP: cc.Vec2;
        const touch_start = (evt: cc.Event.EventTouch) => {
            oldP = evt.getLocation();
        };
        const touch_move = (evt: cc.Event.EventTouch) => {
            const p = evt.getLocation();
            evt.target.x += p.x - oldP.x;
            evt.target.y += p.y - oldP.y;
            oldP = p;
            this.draw();
        };
        this.circle1.on(cc.Node.EventType.TOUCH_START, touch_start);
        this.circle1.on(cc.Node.EventType.TOUCH_MOVE, touch_move);
        this.circle2.on(cc.Node.EventType.TOUCH_START, touch_start);
        this.circle2.on(cc.Node.EventType.TOUCH_MOVE, touch_move);

    }

    private draw(): void {
        this.debug.clear();
        this.debug.circle(0, 0, 4);
        this.debug.circle(this.circle1.x, this.circle1.y, 2);
        this.debug.circle(this.circle2.x, this.circle2.y, 2);
        this.debug.moveTo(0, 0);
        this.debug.lineTo(this.circle1.x, this.circle1.y);
        this.debug.moveTo(0, 0);
        this.debug.lineTo(this.circle2.x, this.circle2.y);
        this.debug.stroke();

        const ix = this.circle1.x / this.w02;
        const iy = this.circle1.y / this.w02;
        const jx = this.circle2.x / this.h02;
        const jy = this.circle2.y / this.h02;

        let i: number = -1;
        for (const vertex of this.vertices) {
            i++;
            this.sp.spriteFrame.vertices.x[i] = this.w02 * (1 + 2 / this.sw * (vertex[0] * ix + vertex[1] * jx));
            this.sp.spriteFrame.vertices.y[i] = this.h02 * (1 - 2 / this.sh * (vertex[0] * iy + vertex[1] * jy));
        }
        this.sp.setVertsDirty();

    }

}
